/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.familiar.ChimeraFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ChimeraFamiliarModel
extends EntityModel<ChimeraFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart head;
    public ModelPart leftBackLeg1;
    public ModelPart snake1;
    public ModelPart leftLeg1;
    public ModelPart goatNeck;
    public ModelPart rightBackLeg1;
    public ModelPart rightLeg1;
    public ModelPart mouth;
    public ModelPart leftEye;
    public ModelPart leftEar;
    public ModelPart mane1;
    public ModelPart mane2;
    public ModelPart mane3;
    public ModelPart mane4;
    public ModelPart mane7;
    public ModelPart rightEar;
    public ModelPart rightEye;
    public ModelPart mane5;
    public ModelPart mane6;
    public ModelPart mane8;
    public ModelPart jaw;
    public ModelPart nose;
    public ModelPart leftBackLeg2;
    public ModelPart leftBackLeg3;
    public ModelPart snake2;
    public ModelPart snake3;
    public ModelPart snake4;
    public ModelPart snakeFlap1;
    public ModelPart snakeFlap2;
    public ModelPart snake5;
    public ModelPart snakeTooth;
    public ModelPart snakeHat1;
    public ModelPart snakeHat2;
    public ModelPart leftLeg2;
    public ModelPart leftLeg3;
    public ModelPart goatHead;
    public ModelPart goatLeftHorn1;
    public ModelPart goatMouth;
    public ModelPart goatRightHorn1;
    public ModelPart goatLeftHorn2;
    public ModelPart goatBeard;
    public ModelPart goatRing;
    public ModelPart goatRightHorn2;
    public ModelPart rightBackLeg2;
    public ModelPart rightBackLeg3;
    public ModelPart rightLeg2;
    public ModelPart rightLeg3;

    public ChimeraFamiliarModel(ModelPart part) {
        this.body = part.getChild("body");
        this.head = this.body.getChild("head");
        this.leftBackLeg1 = this.body.getChild("leftBackLeg1");
        this.snake1 = this.body.getChild("snake1");
        this.leftLeg1 = this.body.getChild("leftLeg1");
        this.goatNeck = this.body.getChild("goatNeck");
        this.rightBackLeg1 = this.body.getChild("rightBackLeg1");
        this.rightLeg1 = this.body.getChild("rightLeg1");
        this.mouth = this.head.getChild("mouth");
        this.leftEye = this.head.getChild("leftEye");
        this.leftEar = this.head.getChild("leftEar");
        this.mane1 = this.head.getChild("mane1");
        this.mane2 = this.head.getChild("mane2");
        this.mane3 = this.head.getChild("mane3");
        this.mane4 = this.head.getChild("mane4");
        this.mane7 = this.head.getChild("mane7");
        this.rightEar = this.head.getChild("rightEar");
        this.rightEye = this.head.getChild("rightEye");
        this.mane5 = this.head.getChild("mane5");
        this.mane6 = this.head.getChild("mane6");
        this.mane8 = this.head.getChild("mane8");
        this.jaw = this.mouth.getChild("jaw");
        this.nose = this.mouth.getChild("nose");
        this.leftBackLeg2 = this.leftBackLeg1.getChild("leftBackLeg2");
        this.leftBackLeg3 = this.leftBackLeg2.getChild("leftBackLeg3");
        this.snake2 = this.snake1.getChild("snake2");
        this.snake3 = this.snake2.getChild("snake3");
        this.snake4 = this.snake3.getChild("snake4");
        this.snakeFlap1 = this.snake3.getChild("snakeFlap1");
        this.snakeFlap2 = this.snake3.getChild("snakeFlap2");
        this.snake5 = this.snake4.getChild("snake5");
        this.snakeTooth = this.snake4.getChild("snakeTooth");
        this.snakeHat1 = this.snake4.getChild("snakeHat1");
        this.snakeHat2 = this.snakeHat1.getChild("snakeHat2");
        this.leftLeg2 = this.leftLeg1.getChild("leftLeg2");
        this.leftLeg3 = this.leftLeg2.getChild("leftLeg3");
        this.goatHead = this.goatNeck.getChild("goatHead");
        this.goatLeftHorn1 = this.goatHead.getChild("goatLeftHorn1");
        this.goatMouth = this.goatHead.getChild("goatMouth");
        this.goatRightHorn1 = this.goatHead.getChild("goatRightHorn1");
        this.goatLeftHorn2 = this.goatLeftHorn1.getChild("goatLeftHorn2");
        this.goatBeard = this.goatMouth.getChild("goatBeard");
        this.goatRing = this.goatMouth.getChild("goatRing");
        this.goatRightHorn2 = this.goatRightHorn1.getChild("goatRightHorn2");
        this.rightBackLeg2 = this.rightBackLeg1.getChild("rightBackLeg2");
        this.rightBackLeg3 = this.rightBackLeg2.getChild("rightBackLeg3");
        this.rightLeg2 = this.rightLeg1.getChild("rightLeg2");
        this.rightLeg3 = this.rightLeg2.getChild("rightLeg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body = parts.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.5f, -5.0f, 5.0f, 5.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(20, 0).addBox(-2.5f, -4.0f, -4.0f, 5.0f, 5.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackLeg1 = body.addOrReplaceChild("leftBackLeg1", CubeListBuilder.create().texOffs(4, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.3f, (float)-0.1f, (float)3.9f, (float)-0.23457225f, (float)0.0f, (float)0.0f));
        PartDefinition snake1 = body.addOrReplaceChild("snake1", CubeListBuilder.create().texOffs(45, 4).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)4.5f, (float)-0.6646214f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg1 = body.addOrReplaceChild("leftLeg1", CubeListBuilder.create().texOffs(46, 11).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)-0.2f, (float)-3.0f, (float)0.43004912f, (float)0.0f, (float)0.0f));
        PartDefinition goatNeck = body.addOrReplaceChild("goatNeck", CubeListBuilder.create().texOffs(0, 15).addBox(-4.0f, -2.0f, -1.0f, 4.0f, 3.0f, 2.0f, false), PartPose.offsetAndRotation((float)-1.5f, (float)-1.0f, (float)0.0f, (float)0.039095376f, (float)-0.23457225f, (float)0.89901906f));
        PartDefinition rightBackLeg1 = body.addOrReplaceChild("rightBackLeg1", CubeListBuilder.create().texOffs(4, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, true), PartPose.offsetAndRotation((float)-2.3f, (float)-0.1f, (float)3.9f, (float)-0.23457225f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg1 = body.addOrReplaceChild("rightLeg1", CubeListBuilder.create().texOffs(46, 11).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, true), PartPose.offsetAndRotation((float)-2.0f, (float)-0.2f, (float)-3.0f, (float)0.43004912f, (float)0.0f, (float)0.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(35, 0).addBox(-1.5f, -1.0f, -3.0f, 3.0f, 2.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.2f, (float)-3.3f, (float)0.43004912f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(44, 0).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.7f, (float)-2.4f, (float)-3.9f, (float)0.0f, (float)0.0f, (float)-0.43633232f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(56, 0).addBox(0.0f, -2.0f, -1.5f, 2.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)-2.9f, (float)-2.0f, (float)-0.11728612f, (float)-0.11728612f, (float)-0.35185838f));
        PartDefinition mane1 = head.addOrReplaceChild("mane1", CubeListBuilder.create().texOffs(3, 28).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 4.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)-3.0f, (float)0.61086524f, (float)0.0f, (float)0.0f));
        PartDefinition mane2 = head.addOrReplaceChild("mane2", CubeListBuilder.create().texOffs(3, 28).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 4.0f, 0.0f, false), PartPose.offsetAndRotation((float)-2.0f, (float)-1.0f, (float)-2.9f, (float)0.6981317f, (float)0.0f, (float)1.5707964f));
        PartDefinition mane3 = head.addOrReplaceChild("mane3", CubeListBuilder.create().texOffs(3, 28).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 4.0f, 0.0f, true), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)-2.9f, (float)0.61086524f, (float)0.0f, (float)-1.5707964f));
        PartDefinition mane4 = head.addOrReplaceChild("mane4", CubeListBuilder.create().texOffs(3, 28).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 4.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-3.0f, (float)0.61086524f, (float)0.0f, (float)((float)Math.PI)));
        PartDefinition mane7 = head.addOrReplaceChild("mane7", CubeListBuilder.create().texOffs(17, 27).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)-1.0f, (float)0.6981317f, (float)0.0f, (float)-1.5707964f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(56, 0).addBox(0.0f, -2.0f, -1.5f, 2.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)-2.0f, (float)-2.9f, (float)-2.0f, (float)-0.11728612f, (float)-0.11728612f, (float)-1.1644837f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(44, 0).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 1.0f, 1.0f, true), PartPose.offsetAndRotation((float)-1.7f, (float)-2.4f, (float)-3.9f, (float)0.0f, (float)0.0f, (float)0.43633232f));
        PartDefinition mane5 = head.addOrReplaceChild("mane5", CubeListBuilder.create().texOffs(17, 27).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)-1.0f, (float)0.6981317f, (float)0.0f, (float)0.0f));
        PartDefinition mane6 = head.addOrReplaceChild("mane6", CubeListBuilder.create().texOffs(17, 27).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)-2.0f, (float)-1.0f, (float)-1.0f, (float)0.6981317f, (float)0.0f, (float)1.5707964f));
        PartDefinition mane8 = head.addOrReplaceChild("mane8", CubeListBuilder.create().texOffs(17, 27).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-1.0f, (float)0.6981317f, (float)0.0f, (float)((float)Math.PI)));
        PartDefinition jaw = mouth.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(47, 0).addBox(-1.5f, -1.0f, -3.0f, 3.0f, 1.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.3f, (float)0.11728612f, (float)0.0f, (float)0.0f));
        PartDefinition nose = mouth.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-0.4f, (float)-2.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackLeg2 = leftBackLeg1.addOrReplaceChild("leftBackLeg2", CubeListBuilder.create().texOffs(57, 3).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)-0.01f, (float)3.3f, (float)-0.1f, (float)0.86009824f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackLeg3 = leftBackLeg2.addOrReplaceChild("leftBackLeg3", CubeListBuilder.create().texOffs(20, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)2.2f, (float)0.5f, (float)-1.2119566f, (float)0.0f, (float)0.0f));
        PartDefinition snake2 = snake1.addOrReplaceChild("snake2", CubeListBuilder.create().texOffs(45, 4).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.4691445f, (float)-0.4691445f, (float)0.0f));
        PartDefinition snake3 = snake2.addOrReplaceChild("snake3", CubeListBuilder.create().texOffs(45, 4).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.4691445f, (float)-0.4691445f, (float)0.0f));
        PartDefinition snake4 = snake3.addOrReplaceChild("snake4", CubeListBuilder.create().texOffs(0, 6).addBox(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.3f, (float)0.5864306f, (float)0.0f, (float)0.0f));
        PartDefinition snakeFlap1 = snake3.addOrReplaceChild("snakeFlap1", CubeListBuilder.create().texOffs(33, 28).addBox(0.0f, -2.0f, 0.0f, 3.0f, 4.0f, 0.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.17453292f, (float)0.0f));
        PartDefinition snakeFlap2 = snake3.addOrReplaceChild("snakeFlap2", CubeListBuilder.create().texOffs(33, 28).addBox(-3.0f, -2.0f, 0.0f, 3.0f, 4.0f, 0.0f, true), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.17453292f, (float)0.0f));
        PartDefinition snake5 = snake4.addOrReplaceChild("snake5", CubeListBuilder.create().texOffs(30, 10).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)0.0f, (float)0.0f, (float)0.50823987f, (float)0.0f, (float)0.0f));
        PartDefinition snakeTooth = snake4.addOrReplaceChild("snakeTooth", CubeListBuilder.create().texOffs(0, 31).addBox(0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.4f, (float)-2.8f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition snakeHat1 = snake4.addOrReplaceChild("snakeHat1", CubeListBuilder.create().texOffs(45, 28).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)1.01f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition snakeHat2 = snakeHat1.addOrReplaceChild("snakeHat2", CubeListBuilder.create().texOffs(53, 28).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg2 = leftLeg1.addOrReplaceChild("leftLeg2", CubeListBuilder.create().texOffs(54, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)3.4f, (float)0.5f, (float)-0.74281216f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg3 = leftLeg2.addOrReplaceChild("leftLeg3", CubeListBuilder.create().texOffs(27, 14).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 1.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)3.2f, (float)0.8f, (float)0.312763f, (float)0.0f, (float)0.0f));
        PartDefinition goatHead = goatNeck.addOrReplaceChild("goatHead", CubeListBuilder.create().texOffs(37, 14).addBox(-3.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)-3.0f, (float)-1.5f, (float)0.2f, (float)0.0f, (float)-0.1972222f, (float)-0.938289f));
        PartDefinition goatLeftHorn1 = goatHead.addOrReplaceChild("goatLeftHorn1", CubeListBuilder.create().texOffs(34, 12).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)-0.3f, (float)-0.7f, (float)-0.8f, (float)-0.17453292f, (float)1.5707964f, (float)0.0f));
        PartDefinition goatMouth = goatHead.addOrReplaceChild("goatMouth", CubeListBuilder.create().texOffs(16, 16).addBox(-3.0f, -1.5f, -1.0f, 3.0f, 3.0f, 2.0f, false), PartPose.offsetAndRotation((float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.19547687f));
        PartDefinition goatRightHorn1 = goatHead.addOrReplaceChild("goatRightHorn1", CubeListBuilder.create().texOffs(34, 12).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-0.3f, (float)-0.7f, (float)0.8f, (float)-0.17453292f, (float)1.5707964f, (float)0.0f));
        PartDefinition goatLeftHorn2 = goatLeftHorn1.addOrReplaceChild("goatLeftHorn2", CubeListBuilder.create().texOffs(12, 15).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)0.2f, (float)1.4f, (float)-0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition goatBeard = goatMouth.addOrReplaceChild("goatBeard", CubeListBuilder.create().texOffs(26, 18).addBox(-3.0f, -1.5f, -1.0f, 3.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition goatRing = goatMouth.addOrReplaceChild("goatRing", CubeListBuilder.create().texOffs(35, 28).addBox(-3.0f, 0.0f, -2.0f, 3.0f, 0.0f, 4.0f, false), PartPose.offsetAndRotation((float)-2.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5864306f));
        PartDefinition goatRightHorn2 = goatRightHorn1.addOrReplaceChild("goatRightHorn2", CubeListBuilder.create().texOffs(12, 15).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, true), PartPose.offsetAndRotation((float)0.01f, (float)0.2f, (float)1.4f, (float)-0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition rightBackLeg2 = rightBackLeg1.addOrReplaceChild("rightBackLeg2", CubeListBuilder.create().texOffs(57, 3).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-0.01f, (float)3.3f, (float)-0.1f, (float)0.86009824f, (float)0.0f, (float)0.0f));
        PartDefinition rightBackLeg3 = rightBackLeg2.addOrReplaceChild("rightBackLeg3", CubeListBuilder.create().texOffs(20, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, true), PartPose.offsetAndRotation((float)0.01f, (float)2.2f, (float)0.5f, (float)-1.2119566f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg2 = rightLeg1.addOrReplaceChild("rightLeg2", CubeListBuilder.create().texOffs(54, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, true), PartPose.offsetAndRotation((float)0.01f, (float)3.4f, (float)0.5f, (float)-0.74281216f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg3 = rightLeg2.addOrReplaceChild("rightLeg3", CubeListBuilder.create().texOffs(27, 14).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 1.0f, 3.0f, true), PartPose.offsetAndRotation((float)0.01f, (float)3.2f, (float)0.8f, (float)0.312763f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.body.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }

    public void setupAnim(ChimeraFamiliarEntity pEntity, float limbSwing, float limbSwingAmount, float pAgeInTicks, float netHeadYaw, float headPitch) {
        boolean isSnakeAttacking = pEntity.getAttackProgress(0.0f) > 0.0f && pEntity.getAttacker() == 3;
        this.showModels(pEntity);
        this.snake2.yRot = 0.0f;
        this.snake3.yRot = 0.0f;
        this.leftLeg3.xRot = 0.31f;
        this.rightLeg3.xRot = 0.31f;
        this.body.xRot = 0.0f;
        if (!isSnakeAttacking) {
            this.snake1.xRot = -0.66f;
            this.snake2.xRot = 0.47f;
            this.snake3.xRot = 0.47f;
            this.snake4.xRot = 0.59f;
        }
        this.goatHead.zRot = -0.94f;
        this.leftLeg1.yRot = 0.0f;
        this.rightLeg1.yRot = 0.0f;
        this.head.yRot = this.toRads(netHeadYaw) * 0.7f;
        this.head.xRot = this.toRads(headPitch) * 0.7f;
        this.snake4.yRot = this.toRads(netHeadYaw) * 0.3f;
        this.snake4.zRot = -this.toRads(netHeadYaw) * 0.3f;
        this.snake1.zRot = Mth.cos((float)(limbSwing * 0.3f)) * 0.1f * limbSwingAmount + this.toRads(0.0f);
        this.snake2.zRot = Mth.cos((float)(limbSwing * 0.3f)) * 0.1f * limbSwingAmount + this.toRads(0.0f);
        this.snake3.zRot = Mth.cos((float)(limbSwing * 0.3f)) * 0.25f * limbSwingAmount + this.toRads(0.0f);
        this.snake4.zRot = -Mth.cos((float)(limbSwing * 0.3f)) * 0.25f * limbSwingAmount;
        this.snake5.xRot = Mth.cos((float)(pAgeInTicks * 0.1f)) * this.toRads(15.0f) + this.toRads(15.0f);
        this.rightBackLeg1.xRot = Mth.cos((float)(limbSwing * 0.7f)) * 0.8f * limbSwingAmount - 0.23f;
        this.leftBackLeg1.xRot = Mth.cos((float)(limbSwing * 0.7f + (float)Math.PI)) * 0.8f * limbSwingAmount - 0.23f;
        this.rightLeg1.xRot = Mth.cos((float)(limbSwing * 0.7f + (float)Math.PI)) * 0.8f * limbSwingAmount + 0.43f;
        this.leftLeg1.xRot = Mth.cos((float)(limbSwing * 0.7f)) * 0.8f * limbSwingAmount + 0.43f;
        if (pEntity.isSitting()) {
            this.leftLeg1.xRot = -this.toRads(15.0f);
            this.rightLeg1.xRot = -this.toRads(15.0f);
            this.leftLeg3.xRot = this.toRads(30.0f);
            this.rightLeg3.xRot = this.toRads(30.0f);
            this.leftBackLeg1.xRot = -this.toRads(62.0f);
            this.rightBackLeg1.xRot = -this.toRads(62.0f);
            this.body.xRot = -this.toRads(20.0f);
            this.leftLeg1.yRot = -this.toRads(10.0f);
            this.rightLeg1.yRot = this.toRads(10.0f);
            this.snake1.zRot = this.toRads(80.0f);
            this.snake2.zRot = this.toRads(0.0f);
            this.snake3.zRot = this.toRads(-20.0f);
            this.snake4.zRot = this.toRads(-65.0f);
            this.snake2.yRot = -this.toRads(20.0f);
            this.snake3.yRot = -this.toRads(20.0f);
            this.snake4.yRot = -this.toRads(20.0f);
            this.snake2.xRot = this.toRads(40.0f);
            this.snake3.xRot = this.toRads(50.0f);
            this.snake4.xRot = this.toRads(60.0f);
            this.snake5.xRot = this.toRads(7.0f);
        }
        if (pEntity.isPartying()) {
            this.head.xRot = Mth.cos((float)(pAgeInTicks * 0.4f)) * this.toRads(30.0f);
            this.goatHead.zRot = -Mth.cos((float)(pAgeInTicks * 0.4f)) * this.toRads(15.0f) - 0.94f;
            this.goatHead.yRot = -0.2f;
            this.snake4.xRot = Mth.cos((float)(pAgeInTicks * 0.4f)) * this.toRads(30.0f) + 0.59f;
        }
    }

    public void prepareMobModel(ChimeraFamiliarEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.goatMouth.zRot = pEntity.getNoseGoatRot(pPartialTick) - 0.2f;
        float attackProgress = pEntity.getAttackProgress(pPartialTick);
        if (attackProgress > 0.0f) {
            switch (pEntity.getAttacker()) {
                case 2: {
                    this.goatNeck.zRot = -Mth.sin((float)(attackProgress * (float)Math.PI * 2.0f)) * this.toRads(30.0f) + 0.9f;
                    break;
                }
                case 3: {
                    this.snake1.xRot = Mth.sin((float)(attackProgress * (float)Math.PI)) * this.toRads(25.0f) - 0.66f;
                    this.snake2.xRot = Mth.sin((float)(attackProgress * (float)Math.PI)) * this.toRads(25.0f) + 0.47f;
                    this.snake3.xRot = Mth.sin((float)(attackProgress * (float)Math.PI)) * this.toRads(25.0f) + 0.47f;
                    this.snake4.xRot = -Mth.sin((float)(attackProgress * (float)Math.PI)) * this.toRads(30.0f) + 0.59f;
                }
            }
        }
    }

    private void showModels(ChimeraFamiliarEntity entityIn) {
        boolean hasFlaps;
        this.snakeFlap1.visible = hasFlaps = entityIn.hasFlaps();
        this.snakeFlap2.visible = hasFlaps;
        this.goatRing.visible = entityIn.hasRing();
        this.snakeHat1.visible = entityIn.hasHat();
        this.goatNeck.visible = entityIn.hasGoat();
        this.goatBeard.visible = entityIn.hasBeard();
    }

    private float toRads(float deg) {
        return (float)Math.toRadians(deg);
    }
}

