/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe.data;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public record EntityIngredient(@Nullable EntityType<?> entityType, @Nullable TagKey<EntityType<?>> tag) implements Predicate<EntityType<?>>
{
    public static final EntityIngredient EMPTY = new EntityIngredient(null, null);
    public static final EntityIngredient ANY = new EntityIngredient(null, TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"any")));
    public static final Codec<EntityIngredient> CODEC = Codec.either((Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").codec(), (Codec)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("tag").codec()).xmap(either -> (EntityIngredient)either.map(EntityIngredient::of, EntityIngredient::of), ingredient -> {
        if (ingredient.entityType != null) {
            return Either.left(ingredient.entityType);
        }
        if (ingredient.tag != null) {
            return Either.right(ingredient.tag);
        }
        throw new IllegalStateException("Empty EntityIngredient cannot be serialized");
    });

    @Override
    public boolean test(@Nullable EntityType<?> entityType) {
        if (entityType == null || this.isEmpty()) {
            return false;
        }
        if (this.entityType != null) {
            return this.entityType.equals(entityType);
        }
        for (Holder holder : BuiltInRegistries.ENTITY_TYPE.getTagOrEmpty(this.tag)) {
            if (!((EntityType)holder.value()).equals(entityType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean test(@Nullable Entity entity) {
        if (this.equals(ANY)) {
            return true;
        }
        return entity != null && this.test(entity.getType());
    }

    public boolean isEmpty() {
        return this.entityType == null && this.tag == null;
    }

    public boolean isType() {
        return this.entityType != null;
    }

    public boolean isTag() {
        return this.tag != null;
    }

    @Nullable
    public EntityType<?> getType() {
        return this.entityType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        EntityType<?> type;
        EntityType<?> entityType;
        if (!(other instanceof EntityIngredient)) return false;
        EntityIngredient entityIngredient = (EntityIngredient)other;
        try {
            type = entityType = entityIngredient.entityType();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        EntityType<?> tag1 = entityType = entityIngredient.tag();
        if (!Objects.equals(this.entityType, type)) return false;
        if (!Objects.equals(this.tag, tag1)) return false;
        return true;
    }

    public static EntityIngredient of(EntityType<?> entityType) {
        return new EntityIngredient(entityType, null);
    }

    public static EntityIngredient of(TagKey<EntityType<?>> tag) {
        return new EntityIngredient(null, tag);
    }
}

