/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.item;

import io.github.foundationgames.automobility.block.SteepSlopeBlock;
import io.github.foundationgames.automobility.item.SlopePlacementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SteepSlopeBlockItem
extends BlockItem {
    public SteepSlopeBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        BlockPos pos = BlockPos.containing((Position)context.getClickLocation());
        Level world = context.getLevel();
        if (world.getBlockState(pos).getBlock() instanceof SteepSlopeBlock) {
            BlockState pState;
            Direction facing = (Direction)world.getBlockState(pos).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Direction playerFacing = context.getHorizontalDirection();
            Direction vOffset = playerFacing == facing ? Direction.DOWN : (playerFacing == facing.getOpposite() ? Direction.UP : null);
            BlockPos place = pos.relative(playerFacing);
            if (vOffset != null) {
                place = place.relative(vOffset);
            }
            if ((pState = world.getBlockState(place)).isAir() || pState.is(Blocks.WATER)) {
                return new SlopePlacementContext((UseOnContext)BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)place, (Direction)Direction.UP), facing);
            }
        }
        return super.updatePlacementContext(context);
    }
}

