/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.entity;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface EntityWithContainer
extends Container {
    public Container underlyingContainer();

    default public int getContainerSize() {
        Container c = this.underlyingContainer();
        if (c != null) {
            return c.getContainerSize();
        }
        return 0;
    }

    default public boolean isEmpty() {
        Container c = this.underlyingContainer();
        if (c != null) {
            return c.isEmpty();
        }
        return true;
    }

    default public ItemStack getItem(int slot) {
        Container c = this.underlyingContainer();
        if (c != null) {
            return c.getItem(slot);
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack removeItem(int slot, int amount) {
        Container c = this.underlyingContainer();
        if (c != null) {
            return c.removeItem(slot, amount);
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        Container c = this.underlyingContainer();
        if (c != null) {
            return c.removeItemNoUpdate(slot);
        }
        return ItemStack.EMPTY;
    }

    default public void setItem(int slot, ItemStack stack) {
        Container c = this.underlyingContainer();
        if (c != null) {
            c.setItem(slot, stack);
        }
    }

    default public void setChanged() {
        Container c = this.underlyingContainer();
        if (c != null) {
            c.setChanged();
        }
    }

    default public boolean stillValid(Player player) {
        Container c = this.underlyingContainer();
        if (c != null) {
            return c.stillValid(player);
        }
        return false;
    }

    default public void clearContent() {
        Container c = this.underlyingContainer();
        if (c != null) {
            c.clearContent();
        }
    }

    default public boolean canPlaceItem(int slot, ItemStack stack) {
        Container c = this.underlyingContainer();
        if (c != null) {
            return c.canPlaceItem(slot, stack);
        }
        return false;
    }

    default public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        Container c = this.underlyingContainer();
        if (c != null) {
            return c.canTakeItem(target, slot, stack);
        }
        return false;
    }
}

