/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import com.mojang.serialization.MapCodec;
import io.github.foundationgames.automobility.block.SlopeBlock;
import io.github.foundationgames.automobility.block.SpecialAutomobileColliderBlock;
import io.github.foundationgames.automobility.item.SlopePlacementContext;
import io.github.foundationgames.automobility.util.AUtils;
import io.github.foundationgames.automobility.util.duck.CollisionArea;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SteepSlopeBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
SpecialAutomobileColliderBlock {
    public static final VoxelShape NORTH_SHAPE;
    public static final VoxelShape SOUTH_SHAPE;
    public static final VoxelShape EAST_SHAPE;
    public static final VoxelShape WEST_SHAPE;
    public static final BooleanProperty WATERLOGGED;
    public static final MapCodec<SteepSlopeBlock> CODEC;

    public SteepSlopeBlock(BlockBehaviour.Properties settings) {
        super(settings.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public CollisionArea getCollisionArea(BlockState state, Level level, BlockPos pos, double downStretch) {
        AABB bounds = new AABB((double)pos.getX(), (double)pos.getY() - 4.0 * downStretch, (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
        double zSlope = 0.0;
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                zSlope = 1.0;
                break;
            }
            case SOUTH: {
                zSlope = -1.0;
            }
        }
        double xSlope = 0.0;
        switch ((Direction)state.getValue((Property)FACING)) {
            case EAST: {
                xSlope = -1.0;
                break;
            }
            case WEST: {
                xSlope = 1.0;
            }
        }
        return new CollisionArea.SlopeArea(bounds, xSlope, zSlope, 0.5);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState;
        if (ctx instanceof SlopePlacementContext) {
            SlopePlacementContext slopeCtx = (SlopePlacementContext)ctx;
            blockState = (BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)FACING, (Comparable)slopeCtx.getSlopeFacing())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getBlockState(ctx.getClickedPos()).is(Blocks.WATER)));
        } else {
            blockState = (BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getBlockState(ctx.getClickedPos()).is(Blocks.WATER)));
        }
        return blockState;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> Shapes.empty();
        };
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    static {
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        CODEC = Block.simpleCodec(SteepSlopeBlock::new);
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (Direction dir : AUtils.HORIZONTAL_DIRS) {
            double ox = switch (dir) {
                case Direction.WEST -> 2.0;
                case Direction.EAST -> -2.0;
                default -> 0.0;
            };
            double oz = switch (dir) {
                case Direction.NORTH -> 2.0;
                case Direction.SOUTH -> -2.0;
                default -> 0.0;
            };
            VoxelShape finalShape = Shapes.empty();
            for (int j = 1; j < 8; ++j) {
                finalShape = Shapes.or((VoxelShape)finalShape, (VoxelShape)SlopeBlock.slopeStep(dir, j * 2).move(ox * (double)j / 16.0, 0.0, oz * (double)j / 16.0));
            }
            shapes.add(finalShape);
        }
        NORTH_SHAPE = (VoxelShape)shapes.get(0);
        SOUTH_SHAPE = (VoxelShape)shapes.get(1);
        EAST_SHAPE = (VoxelShape)shapes.get(2);
        WEST_SHAPE = (VoxelShape)shapes.get(3);
    }
}

