/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.DisplayStat;
import io.github.foundationgames.automobility.automobile.StatContainer;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class AutomobileStats
implements StatContainer<AutomobileStats> {
    public static final ResourceLocation ID = Automobility.rl("automobile");
    public static final DisplayStat<AutomobileStats> STAT_ACCELERATION = new DisplayStat<AutomobileStats>("acceleration", AutomobileStats::getAcceleration);
    public static final DisplayStat<AutomobileStats> STAT_COMFORTABLE_SPEED = new DisplayStat<AutomobileStats>("comfortable_speed", stats -> stats.getComfortableSpeed() * 20.0f);
    public static final DisplayStat<AutomobileStats> STAT_HANDLING = new DisplayStat<AutomobileStats>("handling", AutomobileStats::getHandling);
    public static final DisplayStat<AutomobileStats> STAT_GRIP = new DisplayStat<AutomobileStats>("grip", AutomobileStats::getGrip);
    private float acceleration = 0.0f;
    private float comfortableSpeed = 0.0f;
    private float handling = 0.0f;
    private float grip = 0.0f;

    public void from(AutomobileFrame frame, AutomobileWheel wheel, AutomobileEngine engine) {
        this.acceleration = 1.0f - (frame.weight() + wheel.size()) / 2.0f + 2.0f * engine.torque() / 3.0f;
        this.comfortableSpeed = (engine.speed() * 3.0f + engine.speed() * frame.weight() * 2.0f + engine.speed() * wheel.size()) / 5.7f;
        this.handling = (1.0f - wheel.size() + (1.0f - frame.weight()) + 2.0f) / 4.0f;
        this.grip = (wheel.grip() + frame.weight()) / 2.0f;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public float getComfortableSpeed() {
        return this.comfortableSpeed;
    }

    public float getHandling() {
        return this.handling;
    }

    public float getGrip() {
        return this.grip;
    }

    @Override
    public ResourceLocation containerId() {
        return ID;
    }

    @Override
    public void forEachStat(Consumer<DisplayStat<AutomobileStats>> action) {
        action.accept(STAT_ACCELERATION);
        action.accept(STAT_COMFORTABLE_SPEED);
        action.accept(STAT_HANDLING);
        action.accept(STAT_GRIP);
    }
}

