/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.items.CasterHolder;
import alexthw.ars_elemental.common.items.caster_tools.SpellHorn;
import alexthw.ars_elemental.datagen.Datagen;
import alexthw.ars_elemental.registry.ModItems;
import com.alexthw.sauce.api.item.SpellPrismLens;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.StrippableLog;
import com.hollingsworth.arsnouveau.common.items.AnimBlockItem;
import java.util.HashSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class AEItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = ResourceLocation.withDefaultNamespace((String)"item/generated");
    private static final ResourceLocation HANDHELD = ResourceLocation.withDefaultNamespace((String)"item/handheld");
    private static final ResourceLocation SPAWN_EGG = ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg");

    public AEItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "ars_elemental", existingFileHelper);
    }

    protected void registerModels() {
        HashSet items = new HashSet(ModItems.ITEMS.getEntries());
        Datagen.takeAll(items, i -> i.get() instanceof AnimBlockItem).forEach(this::blockItem);
        Datagen.takeAll(items, i -> i.get() instanceof SpellHorn);
        Datagen.takeAll(items, i -> i.get() instanceof SpellPrismLens);
        Datagen.takeAll(items, i -> i.get() instanceof CasterHolder);
        Datagen.takeAll(items, i -> {
            BlockItem bi;
            Object patt0$temp = i.get();
            return patt0$temp instanceof BlockItem && (bi = (BlockItem)patt0$temp).getBlock() instanceof ArchfruitPod;
        }).forEach(this::generatedItem);
        Datagen.takeAll(items, i -> {
            BlockItem bi;
            Object patt0$temp = i.get();
            return patt0$temp instanceof BlockItem && (bi = (BlockItem)patt0$temp).getBlock() instanceof FenceBlock;
        }).forEach(this::fenceBlockItem);
        Datagen.takeAll(items, i -> {
            BlockItem bi;
            Object patt0$temp = i.get();
            return patt0$temp instanceof BlockItem && ((bi = (BlockItem)patt0$temp).getBlock() instanceof SaplingBlock || bi.getBlock() instanceof FlowerBlock);
        }).forEach(this::blockGeneratedItem);
        Datagen.takeAll(items, i -> i.get() instanceof BlockItem).forEach(this::blockItem);
        Datagen.takeAll(items, i -> i.get() instanceof DiggerItem).forEach(this::handheldItem);
        Datagen.takeAll(items, i -> i.get() instanceof SpawnEggItem).forEach(this::spawnEgg);
        items.forEach(this::generatedItem);
    }

    private void spawnEgg(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        this.withExistingParent(name, SPAWN_EGG);
    }

    private void handheldItem(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        ((ItemModelBuilder)this.withExistingParent(name, HANDHELD)).texture("layer0", ArsElemental.prefix("item/" + name));
    }

    private void generatedItem(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", ArsElemental.prefix("item/" + name));
    }

    private void focusModel(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        ((ItemModelBuilder)this.withExistingParent("item/focus/" + name, GENERATED)).texture("layer0", ArsElemental.prefix("item/" + name));
    }

    private void blockGeneratedItem(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", ArsElemental.prefix("block/" + name));
    }

    private void blockItem(DeferredHolder<Item, ? extends Item> i) {
        BlockItem bi;
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        String root = "block/";
        Object object = i.get();
        if (object instanceof BlockItem && ((bi = (BlockItem)object).getBlock() instanceof RotatedPillarBlock || bi.getBlock() instanceof LeavesBlock || bi.getBlock() instanceof StrippableLog)) {
            root = "block/archwood/";
        }
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(ArsElemental.prefix(root + name)));
    }

    private void fenceBlockItem(DeferredHolder<Item, ? extends Item> i) {
        String name = BuiltInRegistries.ITEM.getKey((Object)((Item)i.get())).getPath();
        String baseName = name.substring(0, name.length() - 6);
        this.fenceInventory(name, ArsElemental.prefix("block/" + baseName));
    }

    @NotNull
    public String getName() {
        return "Ars Elemental Item Models";
    }
}

