/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.armor;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.client.TooltipUtils;
import alexthw.ars_elemental.client.armor.ElementalArmorModel;
import alexthw.ars_elemental.client.armor.ElementalArmorRenderer;
import alexthw.ars_elemental.common.items.armor.AAMaterials;
import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.registry.ModItems;
import com.alexthw.sauce.api.item.IElementalArmor;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.mana.IManaDiscountEquipment;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.setup.registry.MaterialRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class ElementalArmor
extends AnimatedMagicArmor
implements IElementalArmor,
IManaDiscountEquipment {
    final SpellSchool element;
    static Map<String, Holder<ArmorMaterial>> SCHOOL_TO_MATERIAL = new ConcurrentHashMap<String, Holder<ArmorMaterial>>(){
        {
            this.put("fire_heavy", AAMaterials.h_fire);
            this.put("air_heavy", AAMaterials.h_air);
            this.put("earth_heavy", AAMaterials.h_earth);
            this.put("water_heavy", AAMaterials.h_water);
            this.put("fire", AAMaterials.fire);
            this.put("air", AAMaterials.air);
            this.put("earth", AAMaterials.earth);
            this.put("water", AAMaterials.water);
            this.put("fire_light", AAMaterials.l_fire);
            this.put("air_light", AAMaterials.l_air);
            this.put("earth_light", AAMaterials.l_earth);
            this.put("water_light", AAMaterials.l_water);
        }
    };
    EquipmentSlot[] OrderedSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public int getMinTier() {
        return 2;
    }

    public SpellSchool getSchool() {
        return this.element;
    }

    public String getTier() {
        return "medium";
    }

    public int getManaDiscount(ItemStack i, Spell spell) {
        return Mth.ceil((double)this.getDiscount(spell.unsafeList()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        ArmorPerkHolder perkProvider = PerkUtil.getPerkHolder((ItemStack)stack);
        if (perkProvider != null) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{4}).withStyle(ChatFormatting.GOLD));
            perkProvider.appendPerkTooltip(tooltip, stack);
        }
        TooltipUtils.addOnShift(tooltip, () -> this.addInformationAfterShift(stack, context, tooltip, flags), "armor_set");
    }

    public ElementalArmor(ArmorItem.Type slot, SpellSchool element, Holder<ArmorMaterial> material, Item.Properties builder) {
        super(material, slot, builder, new ElementalArmorModel("medium_armor_e").withEmptyAnim());
        this.element = element;
    }

    public static ArmorSet getArmorSetFromElement(SpellSchool school, String tier) {
        return switch (tier) {
            case "light" -> {
                switch (school.getId()) {
                    case "fire": {
                        yield ModItems.FIRE_ARMOR_L;
                    }
                    case "water": {
                        yield ModItems.WATER_ARMOR_L;
                    }
                    case "earth": {
                        yield ModItems.EARTH_ARMOR_L;
                    }
                    case "air": {
                        yield ModItems.AIR_ARMOR_L;
                    }
                }
                yield new ArmorSet.Light("necro", SpellSchools.NECROMANCY);
            }
            case "heavy" -> {
                switch (school.getId()) {
                    case "fire": {
                        yield ModItems.FIRE_ARMOR_H;
                    }
                    case "water": {
                        yield ModItems.WATER_ARMOR_H;
                    }
                    case "earth": {
                        yield ModItems.EARTH_ARMOR_H;
                    }
                    case "air": {
                        yield ModItems.AIR_ARMOR_H;
                    }
                }
                yield new ArmorSet.Heavy("necro", SpellSchools.NECROMANCY);
            }
            default -> {
                switch (school.getId()) {
                    case "fire": {
                        yield ModItems.FIRE_ARMOR;
                    }
                    case "water": {
                        yield ModItems.WATER_ARMOR;
                    }
                    case "earth": {
                        yield ModItems.EARTH_ARMOR;
                    }
                    case "air": {
                        yield ModItems.AIR_ARMOR;
                    }
                }
                yield new ArmorSet.Medium("necro", SpellSchools.NECROMANCY);
            }
        };
    }

    static Holder<ArmorMaterial> schoolToMaterial(String key) {
        return SCHOOL_TO_MATERIAL.getOrDefault(key, (Holder<ArmorMaterial>)MaterialRegistry.MEDIUM);
    }

    private Component getArmorSetTitle(ArmorSet set, int equipped) {
        return Component.translatable((String)set.getTranslationKey()).append(" (" + equipped + " / 4)").withStyle(ChatFormatting.DARK_AQUA);
    }

    public void addArmorSetDescription(ArmorSet set, List<Component> list) {
        list.add((Component)Component.translatable((String)("ars_elemental.armor_set." + set.getName() + ".desc")).withStyle(ChatFormatting.GRAY));
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new ElementalArmorRenderer((GeoModel<AnimatedMagicArmor>)ElementalArmor.this.getArmorModel());
                }
                return this.renderer;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformationAfterShift(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flags) {
        Player player = ArsNouveau.proxy.getPlayer();
        if (player != null) {
            ArmorSet set = ElementalArmor.getArmorSetFromElement(this.element, this.getTier());
            ArrayList<MutableComponent> equippedList = new ArrayList<MutableComponent>();
            int equippedCounter = 0;
            for (EquipmentSlot slot : this.OrderedSlots) {
                Item armor = set.getArmorFromSlot(slot);
                MutableComponent cmp = Component.literal((String)" - ").append(armor.getDefaultInstance().getHoverName());
                if (player.getItemBySlot(slot).getItem() == armor) {
                    cmp.withStyle(ChatFormatting.GREEN);
                    ++equippedCounter;
                } else {
                    cmp.withStyle(ChatFormatting.GRAY);
                }
                equippedList.add(cmp);
            }
            list.add(this.getArmorSetTitle(set, equippedCounter));
            list.addAll(equippedList);
            this.addArmorSetDescription(set, list);
        }
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@NotNull ItemStack stack) {
        return super.getDefaultAttributeModifiers(stack).withModifierAdded((Holder)PerkAttributes.MAX_MANA, new AttributeModifier(ArsNouveau.prefix((String)("max_mana_armor_" + this.type.getName())), (double)((Integer)ConfigHandler.Common.ARMOR_MAX_MANA.get()).intValue(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot())).withModifierAdded((Holder)PerkAttributes.MANA_REGEN_BONUS, new AttributeModifier(ArsNouveau.prefix((String)("mana_regen_armor_" + this.type.getName())), (double)((Integer)ConfigHandler.Common.ARMOR_MANA_REGEN.get()).intValue(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot()));
    }

    @Nullable
    public ResourceLocation getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EquipmentSlot slot, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ArmorMaterial.Layer layer, boolean innerModel) {
        return ResourceLocation.fromNamespaceAndPath((String)"ars_elemental", (String)("textures/armor/" + this.getTier() + "_armor_" + this.getSchool().getId() + ".png"));
    }
}

