/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks;

import alexthw.ars_elemental.common.blocks.EverfullUrnTile;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EverfullUrnBlock
extends TickableModBlock
implements BucketPickup {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    static final VoxelShape VSHAPE = Shapes.join((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), (VoxelShape)Block.box((double)5.5, (double)9.0, (double)5.5, (double)10.5, (double)13.0, (double)10.5), (BooleanOp)BooleanOp.OR);

    public EverfullUrnBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return VSHAPE;
    }

    public void animateTick(@NotNull BlockState state, Level level, BlockPos pos, @NotNull RandomSource random) {
        if (level.getBlockState(pos.above()).isAir()) {
            double i = (double)pos.getX() + 0.5;
            double j = (double)pos.getY() + 1.0;
            double k = (double)pos.getZ() + 0.5;
            for (int c = 0; c < 5; ++c) {
                double d0 = i + ParticleUtil.inRange((double)-0.25, (double)0.25);
                double d1 = j + ParticleUtil.inRange((double)0.0, (double)0.05);
                double d2 = k + ParticleUtil.inRange((double)-0.25, (double)0.25);
                level.addParticle((ParticleOptions)ParticleTypes.SPLASH, d0, d1, d2, 0.0, ParticleUtil.inRange((double)-0.01, (double)0.01), 0.0);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new EverfullUrnTile(pPos, pState);
    }

    @NotNull
    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState pState, Mirror pMirror) {
        return this.rotate(pState, pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    @NotNull
    public ItemStack pickupBlock(Player pPlayer, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new ItemStack((ItemLike)Fluids.WATER.getBucket());
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL);
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound(@NotNull BlockState state) {
        return Optional.of(SoundEvents.BUCKET_FILL);
    }
}

