/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.DirectoryReader;
import guideme.internal.shaded.lucene.index.FilterBinaryDocValues;
import guideme.internal.shaded.lucene.index.FilterDirectoryReader;
import guideme.internal.shaded.lucene.index.FilterLeafReader;
import guideme.internal.shaded.lucene.index.FilterNumericDocValues;
import guideme.internal.shaded.lucene.index.FilterSortedDocValues;
import guideme.internal.shaded.lucene.index.FilterSortedNumericDocValues;
import guideme.internal.shaded.lucene.index.FilterSortedSetDocValues;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.KnnVectorValues;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.PointValues;
import guideme.internal.shaded.lucene.index.QueryTimeout;
import guideme.internal.shaded.lucene.index.SortedDocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.index.SortedSetDocValues;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.KnnCollector;
import guideme.internal.shaded.lucene.search.VectorScorer;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.automaton.CompiledAutomaton;
import java.io.IOException;
import java.util.Objects;

public class ExitableDirectoryReader
extends FilterDirectoryReader {
    private final QueryTimeout queryTimeout;

    private static KnnVectorValues.DocIndexIterator createExitableIterator(final KnnVectorValues.DocIndexIterator delegate, final QueryTimeout queryTimeout) {
        return new KnnVectorValues.DocIndexIterator(){
            private int nextCheck;

            @Override
            public int index() {
                return delegate.index();
            }

            @Override
            public int docID() {
                return delegate.docID();
            }

            @Override
            public int nextDoc() throws IOException {
                int doc = delegate.nextDoc();
                if (doc >= this.nextCheck) {
                    this.checkAndThrow();
                    this.nextCheck = doc + 1000;
                }
                return doc;
            }

            @Override
            public long cost() {
                return delegate.cost();
            }

            @Override
            public int advance(int target) throws IOException {
                int doc = delegate.advance(target);
                if (doc >= this.nextCheck) {
                    this.checkAndThrow();
                    this.nextCheck = doc + 1000;
                }
                return doc;
            }

            private void checkAndThrow() {
                if (queryTimeout.shouldExit()) {
                    throw new ExitingReaderException("The request took too long to iterate over knn vector values. Timeout: " + queryTimeout.toString() + ", KnnVectorValues=" + String.valueOf(delegate));
                }
                if (Thread.interrupted()) {
                    throw new ExitingReaderException("Interrupted while iterating over knn vector values. KnnVectorValues=" + String.valueOf(delegate));
                }
            }
        };
    }

    public ExitableDirectoryReader(DirectoryReader in, QueryTimeout queryTimeout) throws IOException {
        super(in, new ExitableSubReaderWrapper(queryTimeout));
        this.queryTimeout = Objects.requireNonNull(queryTimeout);
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        Objects.requireNonNull(this.queryTimeout, "Query timeout must not be null");
        return new ExitableDirectoryReader(in, this.queryTimeout);
    }

    public static DirectoryReader wrap(DirectoryReader in, QueryTimeout queryTimeout) throws IOException {
        Objects.requireNonNull(queryTimeout, "Query timeout must not be null");
        return new ExitableDirectoryReader(in, queryTimeout);
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    @Override
    public String toString() {
        return "ExitableDirectoryReader(" + this.in.toString() + ")";
    }

    public static class ExitableSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final QueryTimeout queryTimeout;

        public ExitableSubReaderWrapper(QueryTimeout queryTimeout) {
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
        }

        @Override
        public LeafReader wrap(LeafReader reader) {
            return new ExitableFilterAtomicReader(reader, this.queryTimeout);
        }
    }

    public static class ExitableTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private static final int NUM_CALLS_PER_TIMEOUT_CHECK = 15;
        private int calls;
        private final QueryTimeout queryTimeout;

        public ExitableTermsEnum(TermsEnum termsEnum, QueryTimeout queryTimeout) {
            super(termsEnum);
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
            this.checkTimeoutWithSampling();
        }

        private void checkTimeoutWithSampling() {
            if ((this.calls++ & 0xF) == 0) {
                if (this.queryTimeout.shouldExit()) {
                    throw new ExitingReaderException("The request took too long to iterate over terms. Timeout: " + this.queryTimeout.toString() + ", TermsEnum=" + String.valueOf(this.in));
                }
                if (Thread.interrupted()) {
                    throw new ExitingReaderException("Interrupted while iterating over terms. TermsEnum=" + String.valueOf(this.in));
                }
            }
        }

        @Override
        public BytesRef next() throws IOException {
            this.checkTimeoutWithSampling();
            return this.in.next();
        }
    }

    public static class ExitableTerms
    extends FilterLeafReader.FilterTerms {
        private final QueryTimeout queryTimeout;

        public ExitableTerms(Terms terms, QueryTimeout queryTimeout) {
            super(terms);
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new ExitableTermsEnum(this.in.intersect(compiled, startTerm), this.queryTimeout);
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new ExitableTermsEnum(this.in.iterator(), this.queryTimeout);
        }

        @Override
        public BytesRef getMin() throws IOException {
            return this.in.getMin();
        }

        @Override
        public BytesRef getMax() throws IOException {
            return this.in.getMax();
        }
    }

    private static class ExitableIntersectVisitor
    implements PointValues.IntersectVisitor {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 16;
        private PointValues.IntersectVisitor in;
        private final QueryTimeout queryTimeout;
        private int calls;

        private ExitableIntersectVisitor(QueryTimeout queryTimeout) {
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
        }

        private void setIntersectVisitor(PointValues.IntersectVisitor in) {
            this.in = in;
        }

        private void checkAndThrowWithSampling() {
            if (this.calls++ % 16 == 0) {
                this.checkAndThrow();
            }
        }

        private void checkAndThrow() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to intersect point values. Timeout: " + this.queryTimeout.toString() + ", PointValues=" + String.valueOf(this.in));
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while intersecting point values. PointValues=" + String.valueOf(this.in));
            }
        }

        @Override
        public void visit(int docID) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID);
        }

        @Override
        public void visit(int docID, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID, packedValue);
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.checkAndThrow();
            return this.in.compare(minPackedValue, maxPackedValue);
        }

        @Override
        public void grow(int count) {
            this.checkAndThrow();
            this.in.grow(count);
        }
    }

    private static class ExitablePointTree
    implements PointValues.PointTree {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 16;
        private final PointValues pointValues;
        private final PointValues.PointTree in;
        private final ExitableIntersectVisitor exitableIntersectVisitor;
        private final QueryTimeout queryTimeout;
        private int calls;

        private ExitablePointTree(PointValues pointValues, PointValues.PointTree in, QueryTimeout queryTimeout) {
            this.pointValues = pointValues;
            this.in = in;
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
            this.exitableIntersectVisitor = new ExitableIntersectVisitor(queryTimeout);
        }

        private void checkAndThrowWithSampling() {
            if (this.calls++ % 16 == 0) {
                this.checkAndThrow();
            }
        }

        private void checkAndThrow() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to intersect point values. Timeout: " + String.valueOf(this.queryTimeout) + ", PointValues=" + String.valueOf(this.pointValues));
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while intersecting point values. PointValues=" + String.valueOf(this.in));
            }
        }

        @Override
        public PointValues.PointTree clone() {
            this.checkAndThrow();
            return new ExitablePointTree(this.pointValues, this.in.clone(), this.queryTimeout);
        }

        @Override
        public boolean moveToChild() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToChild();
        }

        @Override
        public boolean moveToSibling() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToSibling();
        }

        @Override
        public boolean moveToParent() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToParent();
        }

        @Override
        public byte[] getMinPackedValue() {
            this.checkAndThrowWithSampling();
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() {
            this.checkAndThrowWithSampling();
            return this.in.getMaxPackedValue();
        }

        @Override
        public long size() {
            this.checkAndThrow();
            return this.in.size();
        }

        @Override
        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
            this.checkAndThrow();
            this.in.visitDocIDs(visitor);
        }

        @Override
        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
            this.checkAndThrow();
            this.exitableIntersectVisitor.setIntersectVisitor(visitor);
            this.in.visitDocValues(this.exitableIntersectVisitor);
        }
    }

    private static class ExitablePointValues
    extends PointValues {
        private final PointValues in;
        private final QueryTimeout queryTimeout;

        private ExitablePointValues(PointValues in, QueryTimeout queryTimeout) {
            this.in = in;
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
            this.checkAndThrow();
        }

        private void checkAndThrow() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to iterate over point values. Timeout: " + this.queryTimeout.toString() + ", PointValues=" + String.valueOf(this.in));
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while iterating over point values. PointValues=" + String.valueOf(this.in));
            }
        }

        @Override
        public PointValues.PointTree getPointTree() throws IOException {
            this.checkAndThrow();
            return new ExitablePointTree(this.in, this.in.getPointTree(), this.queryTimeout);
        }

        @Override
        public byte[] getMinPackedValue() throws IOException {
            this.checkAndThrow();
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() throws IOException {
            this.checkAndThrow();
            return this.in.getMaxPackedValue();
        }

        @Override
        public int getNumDimensions() throws IOException {
            this.checkAndThrow();
            return this.in.getNumDimensions();
        }

        @Override
        public int getNumIndexDimensions() throws IOException {
            this.checkAndThrow();
            return this.in.getNumIndexDimensions();
        }

        @Override
        public int getBytesPerDimension() throws IOException {
            this.checkAndThrow();
            return this.in.getBytesPerDimension();
        }

        @Override
        public long size() {
            this.checkAndThrow();
            return this.in.size();
        }

        @Override
        public int getDocCount() {
            this.checkAndThrow();
            return this.in.getDocCount();
        }
    }

    public static class ExitableFilterAtomicReader
    extends FilterLeafReader {
        private final QueryTimeout queryTimeout;
        static final int DOCS_BETWEEN_TIMEOUT_CHECK = 1000;

        public ExitableFilterAtomicReader(LeafReader in, QueryTimeout queryTimeout) {
            super(in);
            this.queryTimeout = Objects.requireNonNull(queryTimeout);
        }

        @Override
        public PointValues getPointValues(String field) throws IOException {
            PointValues pointValues = this.in.getPointValues(field);
            if (pointValues == null) {
                return null;
            }
            return new ExitablePointValues(pointValues, this.queryTimeout);
        }

        @Override
        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            if (terms == null) {
                return null;
            }
            return new ExitableTerms(terms, this.queryTimeout);
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        @Override
        public NumericDocValues getNumericDocValues(String field) throws IOException {
            NumericDocValues numericDocValues = super.getNumericDocValues(field);
            if (numericDocValues == null) {
                return null;
            }
            return new FilterNumericDocValues(numericDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            };
        }

        @Override
        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            BinaryDocValues binaryDocValues = super.getBinaryDocValues(field);
            if (binaryDocValues == null) {
                return null;
            }
            return new FilterBinaryDocValues(binaryDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            };
        }

        @Override
        public SortedDocValues getSortedDocValues(String field) throws IOException {
            SortedDocValues sortedDocValues = super.getSortedDocValues(field);
            if (sortedDocValues == null) {
                return null;
            }
            return new FilterSortedDocValues(sortedDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            };
        }

        @Override
        public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
            SortedNumericDocValues sortedNumericDocValues = super.getSortedNumericDocValues(field);
            if (sortedNumericDocValues == null) {
                return null;
            }
            return new FilterSortedNumericDocValues(sortedNumericDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            };
        }

        @Override
        public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
            SortedSetDocValues sortedSetDocValues = super.getSortedSetDocValues(field);
            if (sortedSetDocValues == null) {
                return null;
            }
            return new FilterSortedSetDocValues(sortedSetDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            };
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            FloatVectorValues vectorValues = this.in.getFloatVectorValues(field);
            if (vectorValues == null) {
                return null;
            }
            return new ExitableFloatVectorValues(vectorValues);
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            ByteVectorValues vectorValues = this.in.getByteVectorValues(field);
            if (vectorValues == null) {
                return null;
            }
            return new ExitableByteVectorValues(vectorValues);
        }

        @Override
        public void searchNearestVectors(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
            final Bits updatedAcceptDocs = acceptDocs == null ? new Bits.MatchAllBits(this.maxDoc()) : acceptDocs;
            Bits timeoutCheckingAcceptDocs = new Bits(){
                private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 16;
                private int calls;

                @Override
                public boolean get(int index) {
                    if (this.calls++ % 16 == 0) {
                        this.checkAndThrowForSearchVectors();
                    }
                    return updatedAcceptDocs.get(index);
                }

                @Override
                public int length() {
                    return updatedAcceptDocs.length();
                }
            };
            this.in.searchNearestVectors(field, target, knnCollector, timeoutCheckingAcceptDocs);
        }

        @Override
        public void searchNearestVectors(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
            final Bits updatedAcceptDocs = acceptDocs == null ? new Bits.MatchAllBits(this.maxDoc()) : acceptDocs;
            Bits timeoutCheckingAcceptDocs = new Bits(){
                private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 16;
                private int calls;

                @Override
                public boolean get(int index) {
                    if (this.calls++ % 16 == 0) {
                        this.checkAndThrowForSearchVectors();
                    }
                    return updatedAcceptDocs.get(index);
                }

                @Override
                public int length() {
                    return updatedAcceptDocs.length();
                }
            };
            this.in.searchNearestVectors(field, target, knnCollector, timeoutCheckingAcceptDocs);
        }

        private void checkAndThrowForSearchVectors() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to search nearest vectors. Timeout: " + this.queryTimeout.toString() + ", Reader=" + String.valueOf(this.in));
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while searching nearest vectors. Reader=" + String.valueOf(this.in));
            }
        }

        private void checkAndThrow(DocIdSetIterator in) {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to iterate over doc values. Timeout: " + this.queryTimeout.toString() + ", DocValues=" + String.valueOf(in));
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while iterating over doc values. DocValues=" + String.valueOf(in));
            }
        }

        private class ExitableFloatVectorValues
        extends FloatVectorValues {
            private final FloatVectorValues vectorValues;

            public ExitableFloatVectorValues(FloatVectorValues vectorValues) {
                this.vectorValues = vectorValues;
            }

            @Override
            public int dimension() {
                return this.vectorValues.dimension();
            }

            @Override
            public float[] vectorValue(int ord) throws IOException {
                return this.vectorValues.vectorValue(ord);
            }

            @Override
            public int ordToDoc(int ord) {
                return this.vectorValues.ordToDoc(ord);
            }

            @Override
            public int size() {
                return this.vectorValues.size();
            }

            @Override
            public KnnVectorValues.DocIndexIterator iterator() {
                return ExitableDirectoryReader.createExitableIterator(this.vectorValues.iterator(), ExitableFilterAtomicReader.this.queryTimeout);
            }

            @Override
            public VectorScorer scorer(float[] target) throws IOException {
                return this.vectorValues.scorer(target);
            }

            @Override
            public FloatVectorValues copy() {
                throw new UnsupportedOperationException();
            }
        }

        private class ExitableByteVectorValues
        extends ByteVectorValues {
            private final ByteVectorValues vectorValues;

            public ExitableByteVectorValues(ByteVectorValues vectorValues) {
                this.vectorValues = vectorValues;
            }

            @Override
            public int dimension() {
                return this.vectorValues.dimension();
            }

            @Override
            public int size() {
                return this.vectorValues.size();
            }

            @Override
            public byte[] vectorValue(int ord) throws IOException {
                return this.vectorValues.vectorValue(ord);
            }

            @Override
            public int ordToDoc(int ord) {
                return this.vectorValues.ordToDoc(ord);
            }

            @Override
            public KnnVectorValues.DocIndexIterator iterator() {
                return ExitableDirectoryReader.createExitableIterator(this.vectorValues.iterator(), ExitableFilterAtomicReader.this.queryTimeout);
            }

            @Override
            public VectorScorer scorer(byte[] target) throws IOException {
                return this.vectorValues.scorer(target);
            }

            @Override
            public ByteVectorValues copy() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class ExitingReaderException
    extends RuntimeException {
        public ExitingReaderException(String msg) {
            super(msg);
        }
    }
}

