/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.kubejs;

import com.tom.createores.CreateOreExcavation;
import com.tom.createores.kubejs.ComponentComponent;
import com.tom.createores.kubejs.KubeJSUtil;
import com.tom.createores.kubejs.PlacementJS;
import com.tom.createores.kubejs.RandomSpreadStructurePlacementJS;
import com.tom.createores.util.ThreeState;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.EnumComponent;
import dev.latvian.mods.kubejs.recipe.component.ItemStackComponent;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.StringComponent;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class VeinRecipeJS
extends KubeRecipe {
    public static final KubeRecipeFactory RECIPE_FACTORY = new KubeRecipeFactory(CreateOreExcavation.VEIN_RECIPES.getId(), VeinRecipeJS.class, VeinRecipeJS::new);
    public static final RecipeKey<ItemStack> ICON = ItemStackComponent.ITEM_STACK.otherKey("icon");
    public static final RecipeKey<Component> NAME = ComponentComponent.INSTANCE.otherKey("name");
    public static final RecipeKey<RandomSpreadStructurePlacementJS> PLACEMENT = PlacementJS.INSTANCE.otherKey("placement");
    public static final RecipeKey<Integer> PRIORITY = NumberComponent.INT.range(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)).otherKey("priority").defaultOptional();
    public static final RecipeKey<ThreeState> FINITE = EnumComponent.of((String)"ThreeState", ThreeState.class, ThreeState.CODEC).otherKey("finite").defaultOptional();
    public static final RecipeKey<Float> AMOUNT_MIN = NumberComponent.floatRange((float)0.0f, (float)Float.MAX_VALUE).otherKey("amountMultiplierMin").defaultOptional();
    public static final RecipeKey<Float> AMOUNT_MAX = NumberComponent.floatRange((float)0.0f, (float)Float.MAX_VALUE).otherKey("amountMultiplierMax").defaultOptional();
    public static final RecipeKey<String> BIOME_WHITELIST = StringComponent.ID.otherKey("biomeWhitelist").defaultOptional();
    public static final RecipeKey<String> BIOME_BLACKLIST = StringComponent.ID.otherKey("biomeBlacklist").defaultOptional();
    public static final RecipeSchema SCHEMA = new RecipeSchema(new RecipeKey[]{NAME, ICON, PLACEMENT, PRIORITY, FINITE, AMOUNT_MIN, AMOUNT_MAX, BIOME_WHITELIST, BIOME_BLACKLIST}).uniqueIds(List.of(PLACEMENT, PRIORITY)).constructor(new RecipeKey[]{NAME, ICON}).function("alwaysInfinite", KubeJSUtil.wrapFunc(VeinRecipeJS::alwaysInfinite)).function("alwaysFinite", KubeJSUtil.wrapFunc(VeinRecipeJS::alwaysFinite)).function("defaultFinite", KubeJSUtil.wrapFunc(VeinRecipeJS::defaultFinite)).function("veinSize", KubeJSUtil.wrapFunc(Float.TYPE, Float.TYPE, VeinRecipeJS::veinSize)).function("biomeWhitelist", KubeJSUtil.wrapFunc(String.class, VeinRecipeJS::biomeWhitelist)).function("biomeBlacklist", KubeJSUtil.wrapFunc(String.class, VeinRecipeJS::biomeBlacklist)).function("placement", KubeJSUtil.wrapFunc(Integer.TYPE, Integer.TYPE, Integer.TYPE, VeinRecipeJS::placement)).function("spread", KubeJSUtil.wrapFunc(RandomSpreadType.class, VeinRecipeJS::spread)).function("reduction", KubeJSUtil.wrapFunc(StructurePlacement.FrequencyReductionMethod.class, VeinRecipeJS::reduction)).function("priority", KubeJSUtil.wrapFunc(Integer.TYPE, VeinRecipeJS::priority)).factory(RECIPE_FACTORY);

    public void initValues(boolean created) {
        super.initValues(created);
        if (created) {
            this.setValue(PLACEMENT, new RandomSpreadStructurePlacementJS(64, 8, 0));
            this.setValue(PRIORITY, 0);
            this.setValue(AMOUNT_MIN, Float.valueOf(1.0f));
            this.setValue(AMOUNT_MAX, Float.valueOf(2.0f));
            this.setValue(FINITE, (Object)ThreeState.DEFAULT);
        }
    }

    public VeinRecipeJS alwaysInfinite() {
        this.setValue(FINITE, (Object)ThreeState.NEVER);
        return this;
    }

    public VeinRecipeJS alwaysFinite() {
        this.setValue(FINITE, (Object)ThreeState.ALWAYS);
        return this;
    }

    public VeinRecipeJS defaultFinite() {
        this.setValue(FINITE, (Object)ThreeState.DEFAULT);
        return this;
    }

    public VeinRecipeJS veinSize(float min, float max) {
        this.setValue(AMOUNT_MIN, Float.valueOf(min));
        this.setValue(AMOUNT_MAX, Float.valueOf(max));
        return this;
    }

    public VeinRecipeJS biomeWhitelist(String tag) {
        this.setValue(BIOME_WHITELIST, tag);
        return this;
    }

    public VeinRecipeJS biomeBlacklist(String tag) {
        this.setValue(BIOME_BLACKLIST, tag);
        return this;
    }

    public VeinRecipeJS placement(int spacing, int separation, int salt) {
        RandomSpreadStructurePlacementJS p = (RandomSpreadStructurePlacementJS)this.getValue(PLACEMENT);
        p.spacing = spacing;
        p.separation = separation;
        p.salt = salt;
        this.save();
        return this;
    }

    public VeinRecipeJS spread(RandomSpreadType spread) {
        ((RandomSpreadStructurePlacementJS)this.getValue(VeinRecipeJS.PLACEMENT)).spreadType = spread;
        this.save();
        return this;
    }

    public VeinRecipeJS reduction(StructurePlacement.FrequencyReductionMethod freqReduction) {
        ((RandomSpreadStructurePlacementJS)this.getValue(VeinRecipeJS.PLACEMENT)).frequencyReductionMethod = freqReduction;
        this.save();
        return this;
    }

    public VeinRecipeJS priority(int priority) {
        this.setValue(PRIORITY, priority);
        return this;
    }
}

