/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.item;

import com.tom.createores.CreateOreExcavation;
import com.tom.createores.Registration;
import com.tom.createores.components.OreVeinAtlasDataComponent;
import com.tom.createores.menu.OreVeinAtlasMenu;
import com.tom.createores.network.OreVeinAtlasClickPacket;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import com.tom.createores.util.PlatformMenuProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class OreVeinAtlasItem
extends Item
implements PlatformMenuProvider {
    public static final String DISCOVERED = "discovered";
    public static final String EXCLUDE = "exclude";
    public static final String VEINS = "veins";
    public static final String TARGET = "veinTarget";
    public static final String SIZE = "size";
    public static final String DIMENSION = "dim";
    public static final String POS_X = "x";
    public static final String POS_Z = "z";
    public static final String VEIN_ID = "id";
    public static final String HIDE = "hide";

    public OreVeinAtlasItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public void addVein(Player player, ItemStack is, RecipeHolder<VeinRecipe> vein, DimChunkPos pos, float randomMul) {
        OreVeinAtlasDataComponent.OreVeinData vn;
        player.displayClientMessage((Component)Component.translatable((String)"chat.coe.sampleDrill.addedToAtlas"), false);
        OreVeinAtlasDataComponent.OreVeinAtlasData comp = new OreVeinAtlasDataComponent.OreVeinAtlasData((OreVeinAtlasDataComponent)is.get(CreateOreExcavation.ORE_VEIN_ATLAS_DATA_COMPONENT));
        if (!comp.discovered().contains(vein.id())) {
            comp.addDiscovered(vein.id());
        }
        if ((vn = comp.veins().get(pos)) == null || !vn.id().equals((Object)vein.id())) {
            comp.addVein(pos, new OreVeinAtlasDataComponent.OreVeinData(vein.id(), randomMul, false));
        }
        if (comp.isEdited()) {
            is.set(CreateOreExcavation.ORE_VEIN_ATLAS_DATA_COMPONENT, (Object)comp.finish());
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (!world.isClientSide) {
            player.openMenu((MenuProvider)this);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        ItemStack heldItem = pPlayer.getMainHandItem();
        return new OreVeinAtlasMenu((MenuType)Registration.VEIN_ATLAS_MENU.get(), pContainerId, pPlayerInventory, heldItem);
    }

    public Component getDisplayName() {
        return this.getDescription();
    }

    public void menuClicked(ItemStack is, OreVeinAtlasClickPacket.Option opt, ResourceLocation id) {
        OreVeinAtlasDataComponent.OreVeinAtlasData comp = new OreVeinAtlasDataComponent.OreVeinAtlasData((OreVeinAtlasDataComponent)is.get(CreateOreExcavation.ORE_VEIN_ATLAS_DATA_COMPONENT));
        switch (opt) {
            case ADD_EXCLUDE: {
                comp.addExclude(id);
                break;
            }
            case REMOVE_EXCLUDE: {
                comp.removeExclude(id);
                break;
            }
            case SET_TARGET: {
                comp.setTarget(id);
                comp.removeExclude(id);
                break;
            }
        }
        if (comp.isEdited()) {
            is.set(CreateOreExcavation.ORE_VEIN_ATLAS_DATA_COMPONENT, (Object)comp.finish());
        }
    }

    public void menuClicked2(ItemStack is, OreVeinAtlasClickPacket.Option opt, int id) {
        OreVeinAtlasDataComponent.OreVeinAtlasData comp = new OreVeinAtlasDataComponent.OreVeinAtlasData((OreVeinAtlasDataComponent)is.get(CreateOreExcavation.ORE_VEIN_ATLAS_DATA_COMPONENT));
        switch (opt) {
            case TOGGLE_HIDE: {
                comp.toggleHide(id);
                break;
            }
            case REMOVE_TARGET: {
                comp.setTarget(null);
                break;
            }
        }
        if (comp.isEdited()) {
            is.set(CreateOreExcavation.ORE_VEIN_ATLAS_DATA_COMPONENT, (Object)comp.finish());
        }
    }
}

