/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.client.PlatformClient;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DrillRenderer<T extends BlockEntity>
extends SafeBlockEntityRenderer<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"createoreexcavation", (String)"drill"), "main");
    private static final ResourceLocation SHAFT = ResourceLocation.tryBuild((String)"createoreexcavation", (String)"textures/entity/shaft.png");
    private final ModelPart head;
    private final ModelPart shaft;
    private final ModelPart rubble;

    public DrillRenderer(BlockEntityRendererProvider.Context dispatcher) {
        ModelPart root = dispatcher.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("head");
        this.shaft = root.getChild("shaft");
        this.rubble = root.getChild("rubble");
    }

    public static LayerDefinition createModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        head.addOrReplaceChild("Bit4_r1", CubeListBuilder.create().texOffs(20, 26).addBox(-1.0f, 6.5f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(12, 16).addBox(-1.5f, 4.5f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(12, 10).addBox(-2.0f, 2.5f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 24).addBox(-2.5f, 0.5f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-5.0f, -2.5f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(3.0f, -2.5f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-2.0f, -2.5f, -5.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-2.0f, -2.5f, 3.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.0f, -2.5f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        partdefinition.addOrReplaceChild("shaft", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition rubble = partdefinition.addOrReplaceChild("rubble", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)24.0f, (float)0.0f));
        rubble.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 22).addBox(-2.2f, -2.8f, -1.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)0.0f, (float)-0.2486f, (float)-0.1618f, (float)0.1217f));
        rubble.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 13).addBox(-8.0f, -3.0f, -1.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)0.0f, (float)-0.0598f, (float)0.0156f, (float)-0.1786f));
        rubble.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 6).addBox(-9.0f, -3.0f, -7.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)0.0f, (float)0.3412f, (float)0.1265f, (float)-0.0937f));
        rubble.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -7.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)0.0f, (float)0.3414f, (float)-0.0741f, (float)0.2054f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderSafe(T pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ItemStack drill;
        pPoseStack.pushPose();
        float f = ((IDrill)pBlockEntity).getFacing().toYRot();
        pPoseStack.translate(0.5, 0.5, 0.5);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(-f));
        pPoseStack.translate(0.0f, ((IDrill)pBlockEntity).getYOffset(), 0.0f);
        pPoseStack.scale(1.0f, -1.0f, -1.0f);
        pPoseStack.pushPose();
        pPoseStack.translate(0.0f, ((IDrill)pBlockEntity).getDrillOffset(), 0.0f);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTick, (float)((IDrill)pBlockEntity).getPrevRotation(), (float)((IDrill)pBlockEntity).getRotation())));
        if (((IDrill)pBlockEntity).shouldRenderShaft()) {
            this.shaft.render(pPoseStack, pBufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)SHAFT)), pPackedLight, pPackedOverlay);
        }
        if (!(drill = ((IDrill)pBlockEntity).getDrill()).isEmpty()) {
            ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)drill.getItem());
            ResourceLocation tex = ResourceLocation.tryBuild((String)rl.getNamespace(), (String)("textures/entity/drill/" + rl.getPath() + ".png"));
            this.head.render(pPoseStack, pBufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)tex)), pPackedLight, pPackedOverlay);
        }
        pPoseStack.popPose();
        BlockPos below = ((IDrill)pBlockEntity).getBelow();
        BlockState state = pBlockEntity.getLevel().getBlockState(below);
        if (((IDrill)pBlockEntity).shouldRenderRubble() && !state.isAir() && !(pBlockEntity.getLevel() instanceof PonderLevel)) {
            try {
                TextureAtlasSprite particle = PlatformClient.getBlockTexture(state, pBlockEntity.getLevel(), below);
                this.rubble.render(pPoseStack, particle.wrap(pBufferSource.getBuffer(RenderType.cutout())), pPackedLight, pPackedOverlay);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        pPoseStack.popPose();
    }
}

