/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.render.attachment.front;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.attachment.front.AutopilotFrontAttachment;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.automobile.model.ModelDefinition;
import io.github.foundationgames.automobility.automobile.render.attachment.front.FrontAttachmentRenderModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AutopilotFrontAttachmentModel
extends FrontAttachmentRenderModel {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(Automobility.rl("automobile/front_attachment/autopilot"), "main");
    public static final int LIGHT_OFF = 656896;
    public static final int GLOW_OFF = 0;
    private final ModelPart light = AutopilotFrontAttachmentModel.getChildSafe(this.root, "light");
    private final ModelPart glow = AutopilotFrontAttachmentModel.getChildSafe(this.root, "glow");
    private int lightColor = 656896;
    private int glowColor = 0;
    private boolean on = false;

    public AutopilotFrontAttachmentModel(EntityRendererProvider.Context ctx, ModelDefinition.RenderMaterial material, ModelLayerLocation layer, Vector3f translation, Vector3f rotation, Vector3f scale) {
        super(ctx, material, layer, translation, rotation, scale);
    }

    @Override
    public void renderOtherLayer(PoseStack matrices, MultiBufferSource consumers, int light, int overlay) {
        this.light.visible = true;
        VertexConsumer buffer = consumers.getBuffer(this.on ? RenderType.eyes((ResourceLocation)TEXTURE_SOLID) : RenderType.entitySolid((ResourceLocation)TEXTURE_SOLID));
        this.light.render(matrices, buffer, light, overlay, 0xFF000000 | this.lightColor);
        if (this.on) {
            this.glow.visible = true;
            buffer = consumers.getBuffer(RenderType.beaconBeam((ResourceLocation)TEXTURE_SOLID, (boolean)true));
            this.glow.render(matrices, buffer, light, overlay, 0x8E000000 | this.glowColor);
        }
    }

    @Override
    public void setDefaultState(float tickDelta) {
        super.setDefaultState(tickDelta);
        this.lightColor = 656896;
        this.glowColor = 0;
        this.on = false;
        this.light.visible = false;
        this.glow.visible = false;
    }

    @Override
    public void setRenderState(@Nullable FrontAttachment attachment, float groundHeight, float tickDelta) {
        super.setRenderState(attachment, groundHeight, tickDelta);
        this.light.visible = false;
        this.glow.visible = false;
        if (attachment instanceof AutopilotFrontAttachment) {
            AutopilotFrontAttachment att = (AutopilotFrontAttachment)attachment;
            AutopilotFrontAttachment.State state = att.getState();
            this.on = false;
            if (state.flashPeriod > 0) {
                int flashTime = att.getAnimationTimer() % (state.flashPeriod * 2);
                if (flashTime / state.flashPeriod == 0) {
                    int subFlashTime;
                    this.on = true;
                    if (state.flashSubPeriod > 0 && (subFlashTime = att.getAnimationTimer() % (state.flashSubPeriod * 2)) / state.flashSubPeriod == 1) {
                        this.on = false;
                    }
                }
            } else {
                this.on = true;
            }
            if (this.on) {
                this.lightColor = state.lightColor;
                this.glowColor = state.glowColor;
            } else {
                this.lightColor = 656896;
                this.glowColor = 0;
            }
        } else {
            this.on = false;
        }
    }
}

