/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.entity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.entity.ErroredEntityRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityRendererMap
implements Map<EntityType<?>, EntityRenderer<?>> {
    private final Map<EntityType<?>, EntityRendererProvider<?>> rendererProviders;
    private final LoadingCache<EntityType<?>, Optional<EntityRenderer<?>>> rendererMap;
    private final EntityRendererProvider.Context context;

    public EntityRendererMap(Map<EntityType<?>, EntityRendererProvider<?>> rendererProviders, EntityRendererProvider.Context context) {
        this.rendererProviders = rendererProviders;
        this.context = context;
        this.rendererMap = CacheBuilder.newBuilder().build((CacheLoader)new RenderConstructor());
    }

    @Override
    public int size() {
        return this.rendererProviders.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rendererProviders.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.rendererProviders.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return false;
    }

    @Override
    public EntityRenderer<?> get(Object o) {
        try {
            Optional renderer = (Optional)this.rendererMap.get((Object)((EntityType)o));
            return renderer.orElse(null);
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public EntityRenderer<?> put(EntityType<?> entityType, EntityRenderer<?> entityRenderer) {
        Optional old = (Optional)this.rendererMap.getIfPresent(entityType);
        this.rendererMap.put(entityType, Optional.ofNullable(entityRenderer));
        return old != null ? (EntityRenderer)old.orElse(null) : null;
    }

    @Override
    public EntityRenderer<?> remove(Object o) {
        Optional old = (Optional)this.rendererMap.getIfPresent(o);
        this.rendererMap.invalidate(o);
        return old != null ? (EntityRenderer)old.orElse(null) : null;
    }

    @Override
    public void putAll(@NotNull Map<? extends EntityType<?>, ? extends EntityRenderer<?>> map) {
        this.rendererMap.putAll(Maps.transformValues(map, Optional::ofNullable));
    }

    @Override
    public void clear() {
        this.rendererMap.invalidateAll();
    }

    @Override
    @NotNull
    public Set<EntityType<?>> keySet() {
        return this.rendererProviders.keySet();
    }

    @Override
    @NotNull
    public Collection<EntityRenderer<?>> values() {
        return new AbstractCollection<EntityRenderer<?>>(){

            @Override
            public Iterator<EntityRenderer<?>> iterator() {
                return Iterators.transform((Iterator)Iterators.unmodifiableIterator(EntityRendererMap.this.rendererProviders.keySet().iterator()), EntityRendererMap.this::get);
            }

            @Override
            public int size() {
                return EntityRendererMap.this.rendererProviders.size();
            }
        };
    }

    @Override
    @NotNull
    public Set<Map.Entry<EntityType<?>, EntityRenderer<?>>> entrySet() {
        return new AbstractSet<Map.Entry<EntityType<?>, EntityRenderer<?>>>(){

            @Override
            public Iterator<Map.Entry<EntityType<?>, EntityRenderer<?>>> iterator() {
                return Iterators.transform((Iterator)Iterators.unmodifiableIterator(EntityRendererMap.this.rendererProviders.keySet().iterator()), x$0 -> new Entry((EntityType<?>)x$0));
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    return EntityRendererMap.this.rendererProviders.containsKey(e.getKey()) && Objects.equals(EntityRendererMap.this.get(e.getKey()), e.getValue());
                }
                return false;
            }

            @Override
            public int size() {
                return EntityRendererMap.this.rendererProviders.size();
            }
        };
    }

    class RenderConstructor
    extends CacheLoader<EntityType<?>, Optional<EntityRenderer<?>>> {
        RenderConstructor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Optional<EntityRenderer<?>> load(EntityType<?> key) throws Exception {
            EntityRendererProvider<?> provider = EntityRendererMap.this.rendererProviders.get(key);
            if (provider == null) {
                return Optional.empty();
            }
            Class<EntityRenderers> clazz = EntityRenderers.class;
            synchronized (EntityRenderers.class) {
                ErroredEntityRenderer renderer;
                try {
                    renderer = provider.create(EntityRendererMap.this.context);
                    ModernFix.LOGGER.info("Loaded entity {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(key));
                }
                catch (RuntimeException e) {
                    ModernFix.LOGGER.error("Failed to create entity model for " + String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey(key)) + ":", (Throwable)e);
                    renderer = new ErroredEntityRenderer(EntityRendererMap.this.context);
                }
                return Optional.ofNullable(renderer);
            }
        }
    }

    private class Entry
    implements Map.Entry<EntityType<?>, EntityRenderer<?>> {
        private final EntityType<?> key;

        private Entry(EntityType<?> key) {
            this.key = key;
        }

        @Override
        public EntityType<?> getKey() {
            return this.key;
        }

        @Override
        public EntityRenderer<?> getValue() {
            return EntityRendererMap.this.get(this.key);
        }

        @Override
        public EntityRenderer<?> setValue(EntityRenderer<?> value) {
            return EntityRendererMap.this.put(this.key, value);
        }
    }
}

