/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.util;

import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public class DeepfriedSoundInstance
implements SoundInstance {
    private final ResourceLocation location;
    private final SoundSource source;
    private final float volume;
    private final float pitch;
    private final double x;
    private final double y;
    private final double z;
    private final boolean looping;
    private final int delay;
    private final SoundInstance.Attenuation attenuation;
    private Sound resolvedSound;

    public DeepfriedSoundInstance(ResourceLocation location, SoundSource source, float volume, float pitch, boolean looping, int delay, SoundInstance.Attenuation attenuation, double x, double y, double z) {
        this.location = location;
        this.source = source;
        this.volume = volume;
        this.pitch = pitch;
        this.looping = looping;
        this.delay = delay;
        this.attenuation = attenuation;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    @Nullable
    public WeighedSoundEvents resolve(SoundManager soundManager) {
        WeighedSoundEvents weighedSoundEvents = soundManager.getSoundEvent(this.location);
        if (weighedSoundEvents != null) {
            this.resolvedSound = weighedSoundEvents.getSound(RandomSource.create());
        }
        return weighedSoundEvents;
    }

    public Sound getSound() {
        if (this.resolvedSound == null) {
            throw new IllegalStateException("Sound has not been resolved. Ensure resolve() is called before playback.");
        }
        return this.resolvedSound;
    }

    public SoundSource getSource() {
        return this.source;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public boolean isRelative() {
        return false;
    }

    public int getDelay() {
        return this.delay;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public SoundInstance.Attenuation getAttenuation() {
        return this.attenuation;
    }
}

