/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pyzpre.createbitterballen.entity.HerringEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HerringModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"modid", (String)"herring"), "main");
    private final ModelPart HerringBackBody;
    private final ModelPart HerringBackFins;
    private final ModelPart HerringBodyBack;
    private final ModelPart HerringBody;
    private static final Logger LOGGER = LogManager.getLogger();

    public HerringModel(ModelPart root) {
        this.HerringBackBody = root.getChild("HerringBackBody");
        this.HerringBackFins = root.getChild("HerringBackFins");
        this.HerringBodyBack = root.getChild("HerringBodyBack");
        this.HerringBody = root.getChild("HerringBody");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition HerringBackBody = partdefinition.addOrReplaceChild("HerringBackBody", CubeListBuilder.create().texOffs(20, 10).addBox(-0.5f, -2.0f, 5.0E-4f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)23.0f, (float)12.0f));
        PartDefinition HerringBackFins = partdefinition.addOrReplaceChild("HerringBackFins", CubeListBuilder.create().texOffs(22, 24).addBox(0.0f, -1.5f, 1.0015f, 0.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 24).addBox(0.0f, 0.5f, 2.0015f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(26, 15).addBox(0.0f, -2.5f, 2.0015f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)23.0f, (float)12.0f));
        PartDefinition HerringBodyBack = partdefinition.addOrReplaceChild("HerringBodyBack", CubeListBuilder.create().texOffs(0, 10).addBox(-1.5f, 1.0f, 0.0f, 3.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.5f, -2.0f, 0.0f, 3.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(20, 0).addBox(0.0f, -3.0f, 0.0f, 0.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(18, 24).addBox(0.0f, 2.0f, 1.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 12).addBox(0.0f, -4.0f, 1.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)23.0f, (float)5.0f));
        PartDefinition HerringBody = partdefinition.addOrReplaceChild("HerringBody", CubeListBuilder.create().texOffs(0, 18).addBox(-1.5f, -2.0f, -7.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(18, 18).addBox(-1.5f, 1.0f, -6.0f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(20, 5).addBox(-1.0f, -2.0f, -9.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)23.0f, (float)6.0f));
        PartDefinition HerringFinLeft_r1 = HerringBody.addOrReplaceChild("HerringFinLeft_r1", CubeListBuilder.create().texOffs(24, 10).addBox(0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)1.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)2.5307f));
        PartDefinition HerringFinRight_r1 = HerringBody.addOrReplaceChild("HerringFinRight_r1", CubeListBuilder.create().texOffs(20, 15).addBox(0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)1.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float backFinsYRot;
        float backBodyYRot;
        float bodyYRot;
        float cycle;
        if (!(entity instanceof HerringEntity)) {
            return;
        }
        HerringEntity herring = (HerringEntity)entity;
        this.HerringBody.setRotation(0.0f, 0.0f, 0.0f);
        this.HerringBackBody.setRotation(0.0f, 0.0f, 0.0f);
        this.HerringBackFins.setRotation(0.0f, 0.0f, 0.0f);
        this.HerringBodyBack.setRotation(0.0f, 0.0f, 0.0f);
        float degToRad = (float)Math.PI / 180;
        if (herring.isSwimming()) {
            float animationSpeed = 5.0f;
            cycle = ageInTicks / animationSpeed % 1.0f;
            bodyYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -10.0f, 0.0f, 10.0f, 0.0f);
            backBodyYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -40.0f, 0.0f, 40.0f, 0.0f);
            backFinsYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -40.0f, 0.0f, 40.0f, 0.0f);
            this.HerringBody.yRot = bodyYRot * degToRad;
            this.HerringBackBody.yRot = backBodyYRot * degToRad;
            this.HerringBackFins.yRot = backFinsYRot * degToRad;
        }
        if (!herring.isInFluidType()) {
            this.HerringBody.zRot = 90.0f * degToRad;
            this.HerringBackBody.zRot = 90.0f * degToRad;
            this.HerringBackFins.zRot = 90.0f * degToRad;
            this.HerringBodyBack.zRot = 90.0f * degToRad;
            float landAnimationSpeed = 8.0f;
            cycle = ageInTicks / landAnimationSpeed % 1.0f;
            bodyYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -5.0f, 0.0f, 5.0f, 0.0f);
            backBodyYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -20.0f, 0.0f, 20.0f, 0.0f);
            backFinsYRot = this.interpolateKeyframes(cycle, 0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.0f, -20.0f, 0.0f, 20.0f, 0.0f);
            this.HerringBody.yRot = bodyYRot * degToRad;
            this.HerringBackBody.yRot = backBodyYRot * degToRad;
            this.HerringBackFins.yRot = backFinsYRot * degToRad;
        }
    }

    private float interpolateKeyframes(float cycle, float k0, float k1, float k2, float k3, float k4, float v0, float v1, float v2, float v3, float v4) {
        float value;
        if (cycle < k1) {
            float t = (cycle - k0) / (k1 - k0);
            value = Mth.lerp((float)t, (float)v0, (float)v1);
        } else if (cycle < k2) {
            float t = (cycle - k1) / (k2 - k1);
            value = Mth.lerp((float)t, (float)v1, (float)v2);
        } else if (cycle < k3) {
            float t = (cycle - k2) / (k3 - k2);
            value = Mth.lerp((float)t, (float)v2, (float)v3);
        } else {
            float t = (cycle - k3) / (k4 - k3);
            value = Mth.lerp((float)t, (float)v3, (float)v4);
        }
        return value;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int packedColor) {
        this.HerringBackBody.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.HerringBackFins.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.HerringBodyBack.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.HerringBody.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

