/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.entity;

import com.pyzpre.createbitterballen.index.ItemRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.NeoForgeMod;

public class HerringEntity
extends AbstractSchoolingFish {
    private boolean isSwimming = false;

    public int getMaxSchoolSize() {
        return 5;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.MOVEMENT_SPEED, 0.6).add(Attributes.FOLLOW_RANGE, 16.0).add(NeoForgeMod.SWIM_SPEED.getDelegate(), 1.0);
    }

    public HerringEntity(EntityType<? extends AbstractSchoolingFish> entityType, Level world) {
        super(entityType, world);
        this.refreshDimensions();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1));
        this.goalSelector.addGoal(2, (Goal)new FollowFlockLeaderGoal((AbstractSchoolingFish)this));
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.getBucketItemStack();
    }

    @Nonnull
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ItemRegistry.HERRING_BUCKET.get());
    }

    @Nonnull
    protected SoundEvent getFlopSound() {
        return SoundEvents.SALMON_FLOP;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SALMON_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SALMON_DEATH;
    }

    protected SoundEvent getHurtSound(@Nonnull DamageSource damageSource) {
        return SoundEvents.SALMON_HURT;
    }

    public void setPos(double x, double y, double z) {
        super.setPos(x, y, z);
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.2;
        this.setBoundingBox(this.getBoundingBox().move(offsetX, offsetY, offsetZ));
    }

    public static boolean canSpawnHere(EntityType<? extends AbstractSchoolingFish> fish, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos).getBlock() == Blocks.WATER;
    }

    public void tick() {
        super.tick();
        this.isSwimming = this.isInWater() && this.getDeltaMovement().lengthSqr() > 1.0E-4;
    }

    public void stopFollowing() {
        if (this.isFollower()) {
            super.stopFollowing();
        }
    }

    public boolean isSwimming() {
        return this.isSwimming;
    }
}

