/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.mechanicalfryer;

import com.mojang.serialization.MapCodec;
import com.pyzpre.createbitterballen.block.mechanicalfryer.MechanicalFryerEntity;
import com.pyzpre.createbitterballen.index.RecipeRegistry;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class DeepFryingRecipe
extends BasinRecipe {
    public static final MapCodec<DeepFryingRecipe> CODEC = ProcessingRecipe.codec(DeepFryingRecipe::new, (MapCodec)ProcessingRecipeParams.CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, DeepFryingRecipe> STREAM_CODEC = ProcessingRecipe.streamCodec(DeepFryingRecipe::new, (StreamCodec)ProcessingRecipeParams.STREAM_CODEC);

    public static boolean match(BasinBlockEntity basin, MechanicalFryerEntity fryer, Recipe<?> recipe) {
        BasinRecipe basinRecipe;
        FilteringBehaviour filter = basin.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.getResultItem((HolderLookup.Provider)basin.getLevel().registryAccess()));
        if (recipe instanceof BasinRecipe && (basinRecipe = (BasinRecipe)recipe).getRollableResults().isEmpty() && !basinRecipe.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)basinRecipe.getFluidResults().get(0));
        }
        if (!filterTest) {
            return false;
        }
        return DeepFryingRecipe.apply(basin, fryer, recipe, true);
    }

    public static boolean apply(SmartInventory inv, BasinBlockEntity basin, MechanicalFryerEntity fryer, Recipe<?> recipe) {
        boolean isDeepFryingRecipe = recipe instanceof DeepFryingRecipe;
        SmartInventory availableItems = fryer.inputInv;
        IFluidHandler availableFluids = (IFluidHandler)basin.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, basin.getBlockPos(), null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)basin.getLevel().getBlockState(basin.getBlockPos().below(1)));
        if (isDeepFryingRecipe && !((DeepFryingRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ItemStack inputStack = availableItems.getStackInSlot(0);
        int itemCount = inputStack.getCount();
        if (itemCount <= 0) {
            return false;
        }
        NonNullList fluidIngredients = ((DeepFryingRecipe)recipe).getFluidIngredients();
        int maxProcessableItems = itemCount;
        for (FluidIngredient fluidIngredient : fluidIngredients) {
            int requiredAmount = fluidIngredient.getRequiredAmount();
            int totalMatchingAmount = 0;
            for (int tank = 0; tank < availableFluids.getTanks(); ++tank) {
                FluidStack fluidInTank = availableFluids.getFluidInTank(tank);
                if (!fluidIngredient.test(fluidInTank)) continue;
                totalMatchingAmount += fluidInTank.getAmount();
            }
            maxProcessableItems = Math.min(maxProcessableItems, totalMatchingAmount / requiredAmount);
        }
        if (maxProcessableItems <= 0) {
            return false;
        }
        for (FluidIngredient fluidIngredient : fluidIngredients) {
            int drainedAmount;
            FluidStack fluidInTank;
            int amountToConsume = fluidIngredient.getRequiredAmount() * maxProcessableItems;
            for (int tank = 0; !(tank >= availableFluids.getTanks() || fluidIngredient.test(fluidInTank = availableFluids.getFluidInTank(tank)) && (amountToConsume -= (drainedAmount = availableFluids.drain(fluidInTank.copyWithAmount(amountToConsume), IFluidHandler.FluidAction.EXECUTE).getAmount())) <= 0); ++tank) {
            }
        }
        inputStack.shrink(maxProcessableItems);
        List<ItemStack> recipeOutputItems = DeepFryingRecipe.generateOutputs(recipe, basin, maxProcessableItems);
        for (ItemStack itemStack : recipeOutputItems) {
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)fryer.outputInv, (ItemStack)itemStack, (boolean)false);
            if (remaining.isEmpty()) continue;
            return false;
        }
        basin.setChanged();
        basin.sendData();
        fryer.sendData();
        fryer.setChanged();
        return true;
    }

    private static boolean apply(BasinBlockEntity basin, MechanicalFryerEntity fryer, Recipe<?> recipe, boolean test) {
        boolean isDeepFryingRecipe = recipe instanceof DeepFryingRecipe;
        SmartInventory availableItems = fryer.inputInv;
        IFluidHandler availableFluids = (IFluidHandler)basin.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, basin.getBlockPos(), null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)basin.getLevel().getBlockState(basin.getBlockPos().below(1)));
        if (isDeepFryingRecipe && !((DeepFryingRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ItemStack inputStack = availableItems.getStackInSlot(0);
        int itemCount = inputStack.getCount();
        if (itemCount <= 0) {
            return false;
        }
        NonNullList fluidIngredients = isDeepFryingRecipe ? ((DeepFryingRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        int maxProcessableItems = itemCount;
        for (FluidIngredient fluidIngredient : fluidIngredients) {
            int requiredAmount = fluidIngredient.getRequiredAmount();
            int totalMatchingAmount = 0;
            for (int tank = 0; tank < availableFluids.getTanks(); ++tank) {
                FluidStack fluidInTank = availableFluids.getFluidInTank(tank);
                if (!fluidIngredient.test(fluidInTank)) continue;
                totalMatchingAmount += fluidInTank.getAmount();
            }
            maxProcessableItems = Math.min(maxProcessableItems, totalMatchingAmount / requiredAmount);
        }
        if (maxProcessableItems <= 0) {
            return false;
        }
        inputStack.shrink(maxProcessableItems);
        for (FluidIngredient fluidIngredient : fluidIngredients) {
            int drainedAmount;
            FluidStack fluidInTank;
            int amountToConsume = fluidIngredient.getRequiredAmount() * maxProcessableItems;
            for (int tank = 0; !(tank >= availableFluids.getTanks() || fluidIngredient.test(fluidInTank = availableFluids.getFluidInTank(tank)) && (amountToConsume -= (drainedAmount = availableFluids.drain(fluidInTank.copyWithAmount(amountToConsume), IFluidHandler.FluidAction.EXECUTE).getAmount())) <= 0); ++tank) {
            }
        }
        List<ItemStack> recipeOutputItems = DeepFryingRecipe.generateOutputs(recipe, basin, maxProcessableItems);
        for (ItemStack itemStack : recipeOutputItems) {
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)fryer.outputInv, (ItemStack)itemStack, (boolean)false);
            if (remaining.isEmpty()) continue;
            return false;
        }
        basin.setChanged();
        basin.sendData();
        fryer.sendData();
        fryer.setChanged();
        return true;
    }

    private static List<ItemStack> generateOutputs(Recipe<?> recipe, BasinBlockEntity basin, int quantity) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (recipe instanceof BasinRecipe) {
            for (ItemStack result : ((BasinRecipe)recipe).rollResults()) {
                ItemStack stack = result.copy();
                stack.setCount(result.getCount() * quantity);
                outputs.add(stack);
            }
            NonNullList fluidResults = ((BasinRecipe)recipe).getFluidResults();
            for (FluidStack fluidResult : fluidResults) {
                FluidStack outputFluidStack = fluidResult.copy();
                outputFluidStack.setAmount(outputFluidStack.getAmount() * quantity);
                if (!DeepFryingRecipe.inputFluidsToBasin(basin, outputFluidStack, false)) continue;
                basin.setChanged();
                basin.sendData();
            }
        } else {
            ItemStack result = recipe.getResultItem((HolderLookup.Provider)basin.getLevel().registryAccess()).copy();
            result.setCount(result.getCount() * quantity);
            outputs.add(result);
        }
        return outputs;
    }

    public static boolean consumeFluids(FluidIngredient fluidIngredient, IFluidHandler fluidHandler, BasinBlockEntity basin, boolean simulate) {
        int amountRequired = fluidIngredient.getRequiredAmount();
        for (FluidStack matchingFluid : fluidIngredient.getMatchingFluidStacks()) {
            FluidStack fluidToDrain = matchingFluid.copyWithAmount(amountRequired);
            FluidStack drained = fluidHandler.drain(fluidToDrain, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
            if (drained.isEmpty() || !FluidStack.matches((FluidStack)drained, (FluidStack)fluidToDrain)) continue;
            if (!simulate) {
                basin.setChanged();
                basin.sendData();
            }
            return true;
        }
        return false;
    }

    private static boolean inputFluidsToBasin(BasinBlockEntity basin, FluidStack fluidStack, boolean simulate) {
        IFluidHandler basinFluidHandler = (IFluidHandler)basin.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, basin.getBlockPos(), null);
        if (basinFluidHandler == null) {
            return false;
        }
        int filled = basinFluidHandler.fill(fluidStack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        if (!simulate && filled == fluidStack.getAmount()) {
            basin.setChanged();
            basin.sendData();
        }
        return filled == fluidStack.getAmount();
    }

    protected DeepFryingRecipe(IRecipeTypeInfo type, ProcessingRecipeParams params) {
        super(type, params);
    }

    public DeepFryingRecipe(ProcessingRecipeParams params) {
        this(RecipeRegistry.DEEP_FRYING, params);
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    protected int getMaxFluidInputCount() {
        return 2;
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(RecipeInput input, @Nonnull Level worldIn) {
        if (input.isEmpty()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(input.getItem(0));
    }

    private static boolean hasMatchingComponents(FluidIngredient fluidIngredient, FluidStack fluidInTank) {
        for (FluidStack matchingFluid : fluidIngredient.getMatchingFluidStacks()) {
            boolean neitherHaveComponents;
            boolean bothHaveComponents = !fluidInTank.getComponents().isEmpty() && !matchingFluid.getComponents().isEmpty();
            boolean bl = neitherHaveComponents = fluidInTank.getComponents().isEmpty() && matchingFluid.getComponents().isEmpty();
            if (!(bothHaveComponents ? fluidInTank.getComponents().equals((Object)matchingFluid.getComponents()) : neitherHaveComponents)) continue;
            return true;
        }
        return false;
    }
}

