/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.sandbox.facet.cutters;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntSupplier;
import org.apache.lucene.ars_nouveau.facet.taxonomy.FacetLabel;
import org.apache.lucene.ars_nouveau.index.DocValues;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.SortedNumericDocValues;
import org.apache.lucene.ars_nouveau.internal.hppc.IntLongHashMap;
import org.apache.lucene.ars_nouveau.internal.hppc.LongIntHashMap;
import org.apache.lucene.ars_nouveau.sandbox.facet.cutters.FacetCutter;
import org.apache.lucene.ars_nouveau.sandbox.facet.cutters.LeafFacetCutter;
import org.apache.lucene.ars_nouveau.sandbox.facet.labels.OrdToLabel;

public final class LongValueFacetCutter
implements FacetCutter,
OrdToLabel {
    private final String field;
    private final LongIntHashMapSyncCompute valueToOrdMap;
    private IntLongHashMap ordToValueMap;
    private final AtomicInteger maxOrdinal;

    public LongValueFacetCutter(String field) {
        this.field = field;
        this.valueToOrdMap = new LongIntHashMapSyncCompute();
        this.ordToValueMap = null;
        this.maxOrdinal = new AtomicInteger(-1);
    }

    @Override
    public LeafFacetCutter createLeafCutter(LeafReaderContext context) throws IOException {
        final SortedNumericDocValues docValues = DocValues.getSortedNumeric(context.reader(), this.field);
        return new LeafFacetCutter(){
            int docValueCount;
            long lastDocValue;
            int docValueCursor;

            @Override
            public boolean advanceExact(int doc) throws IOException {
                if (docValues.advanceExact(doc)) {
                    this.docValueCount = docValues.docValueCount();
                    this.docValueCursor = 0;
                    return true;
                }
                return false;
            }

            @Override
            public int nextOrd() throws IOException {
                while (this.docValueCursor++ < this.docValueCount) {
                    long value = docValues.nextValue();
                    if (this.docValueCursor != 1 && value == this.lastDocValue) continue;
                    this.lastDocValue = value;
                    return LongValueFacetCutter.this.valueToOrdMap.computeIfAbsent(value, LongValueFacetCutter.this.maxOrdinal::incrementAndGet);
                }
                return -1;
            }
        };
    }

    @Override
    public FacetLabel getLabel(int ordinal) {
        if (this.ordToValueMap == null) {
            this.buildOrdToValueMap();
        }
        if (this.ordToValueMap.containsKey(ordinal)) {
            return new FacetLabel(String.valueOf(this.ordToValueMap.get(ordinal)));
        }
        assert (false) : "ordinal=" + ordinal + ", ordToValueMap.size=" + this.ordToValueMap.size() + ", valueToOrdMap.size=" + this.valueToOrdMap.size();
        return null;
    }

    public long getValue(int ordinal) {
        if (this.ordToValueMap == null) {
            this.buildOrdToValueMap();
        }
        return this.ordToValueMap.get(ordinal);
    }

    private void buildOrdToValueMap() {
        this.ordToValueMap = new IntLongHashMap(this.valueToOrdMap.size());
        for (LongIntHashMap.LongIntCursor cursor : this.valueToOrdMap) {
            this.ordToValueMap.put(cursor.value, cursor.key);
        }
    }

    @Override
    public FacetLabel[] getLabels(int[] ordinals) throws IOException {
        FacetLabel[] facetLabels = new FacetLabel[ordinals.length];
        for (int i = 0; i < ordinals.length; ++i) {
            facetLabels[i] = this.getLabel(ordinals[i]);
        }
        return facetLabels;
    }

    private static class LongIntHashMapSyncCompute
    extends LongIntHashMap {
        private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        private final Lock r = this.rwl.readLock();
        private final Lock w = this.rwl.writeLock();

        private LongIntHashMapSyncCompute() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int computeIfAbsent(long key, IntSupplier valueSupplier) {
            int value;
            this.r.lock();
            try {
                value = super.getOrDefault(key, -1);
            }
            finally {
                this.r.unlock();
            }
            if (value == -1) {
                this.w.lock();
                try {
                    int index = super.indexOf(key);
                    if (super.indexExists(index)) {
                        int n = super.indexGet(index);
                        return n;
                    }
                    value = valueSupplier.getAsInt();
                    super.indexInsert(index, key, value);
                    int n = value;
                    return n;
                }
                finally {
                    this.w.unlock();
                }
            }
            return value;
        }
    }
}

