/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.light;

import com.hollingsworth.arsnouveau.common.light.LightManager;
import com.hollingsworth.arsnouveau.setup.config.Config;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DynamLightUtil {
    public static int getSectionCoord(double coord) {
        return DynamLightUtil.getSectionCoord(Mth.floor((double)coord));
    }

    public static int getSectionCoord(int coord) {
        return coord >> 4;
    }

    private static int getLuminance(Entity entity) {
        if (entity.isOnFire() || entity.isCurrentlyGlowing()) {
            return 15;
        }
        if (Config.ENTITY_LIGHT_MAP.containsKey(DynamLightUtil.keyFor(entity))) {
            return Config.ENTITY_LIGHT_MAP.get(DynamLightUtil.keyFor(entity));
        }
        return Math.min(15, LightManager.getValue(entity));
    }

    public static boolean couldGiveLight(Entity entity) {
        Player player;
        return LightManager.getLightRegistry().containsKey(entity.getType()) || Config.ENTITY_LIGHT_MAP.containsKey(DynamLightUtil.keyFor(entity)) || entity instanceof Player && DynamLightUtil.getPlayerLight(player = (Player)entity) > 0 || entity.isOnFire() || entity.isCurrentlyGlowing();
    }

    public static int getPlayerLight(Player player) {
        int max = 0;
        for (ItemStack item : player.getAllSlots()) {
            if (item.isEmpty()) continue;
            max = Math.max(max, Config.ITEM_LIGHTMAP.getOrDefault(DynamLightUtil.keyFor((ItemLike)item.getItem()), 0));
        }
        return max;
    }

    public static int lightForEntity(Entity entity) {
        int light = 0;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            light = DynamLightUtil.getPlayerLight(player);
        }
        if (entity.isOnFire() || entity.isCurrentlyGlowing()) {
            return 15;
        }
        if (light < 15 && LightManager.containsEntity((EntityType<? extends Entity>)entity.getType())) {
            int entityLuminance = DynamLightUtil.getLuminance(entity);
            return Math.max(entityLuminance, light);
        }
        return Math.min(15, light);
    }

    public static int fromItemLike(ItemLike itemLike) {
        return Config.ITEM_LIGHTMAP.getOrDefault(DynamLightUtil.keyFor(itemLike), 0);
    }

    public static ResourceLocation keyFor(Entity entity) {
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
    }

    public static ResourceLocation keyFor(ItemLike itemLike) {
        return BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem());
    }
}

