/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.crafting.recipes.AlakarkinosRecipe;
import com.hollingsworth.arsnouveau.common.entity.Alakarkinos;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos.CrabState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos.DecideCrabActionState;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class SpawnLootState
extends CrabState {
    boolean backToHat;
    int waitTicks;
    AlakarkinosRecipe recipe;

    public SpawnLootState(Alakarkinos alakarkinos, AlakarkinosRecipe recipe) {
        super(alakarkinos);
        this.recipe = recipe;
    }

    @Override
    public void onEnd() {
        super.onEnd();
        this.alakarkinos.lookAt = null;
    }

    @Override
    @Nullable
    public CrabState tick() {
        BlockPos hatPos = this.alakarkinos.hatPos;
        if (hatPos == null || this.alakarkinos.getHome() == null) {
            return new DecideCrabActionState(this.alakarkinos);
        }
        if (this.waitTicks > 0) {
            --this.waitTicks;
            return null;
        }
        this.alakarkinos.lookAt = Vec3.atCenterOf((Vec3i)hatPos);
        if (BlockUtil.distanceFrom(this.alakarkinos.blockPosition(), hatPos) > 2.0) {
            this.alakarkinos.getNavigation().moveTo((double)hatPos.getX() + 0.5, (double)hatPos.getY() + 0.5, (double)hatPos.getZ() + 0.5, 1.0);
            return null;
        }
        if (!this.backToHat) {
            this.backToHat = true;
            this.waitTicks = 60;
            this.alakarkinos.getEntityData().set(Alakarkinos.BLOWING_AT, Optional.of(hatPos));
            this.alakarkinos.setBlowingBubbles(true);
            this.alakarkinos.getNavigation().stop();
            return null;
        }
        this.alakarkinos.setBlowingBubbles(false);
        this.alakarkinos.findBlockCooldown = 1200;
        ItemStack loot = this.getLoot();
        EntityFlyingItem.spawn(this.alakarkinos.getHome(), (ServerLevel)this.alakarkinos.level, hatPos, this.alakarkinos.getHome().above()).setStack(loot).getEntityData().set(EntityFlyingItem.IS_BUBBLE, (Object)true);
        IItemHandler handler = (IItemHandler)this.alakarkinos.level.getCapability(Capabilities.ItemHandler.BLOCK, this.alakarkinos.getHome(), null);
        ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)loot, (boolean)false);
        return new DecideCrabActionState(this.alakarkinos);
    }

    public ItemStack getLoot() {
        Level level = this.alakarkinos.level;
        LootTable loottable = this.alakarkinos.level.getServer().reloadableRegistries().getLootTable(this.recipe.table());
        ANFakePlayer player = ANFakePlayer.getPlayer((ServerLevel)level);
        LootParams lootparams = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)this.alakarkinos.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.CHEST);
        ObjectArrayList objectarraylist = loottable.getRandomItems(lootparams, this.alakarkinos.level.random);
        return objectarraylist.isEmpty() ? ItemStack.EMPTY : (ItemStack)objectarraylist.getFirst();
    }
}

