/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.wixie;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.entity.goal.ExtendedRangeGoal;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FindPotionGoal
extends ExtendedRangeGoal {
    EntityWixie wixie;
    BlockPos movePos;
    boolean found;
    PotionContents potionNeeded;

    public FindPotionGoal(EntityWixie wixie) {
        super(15);
        this.wixie = wixie;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    @Override
    public void start() {
        super.start();
        BlockEntity tileEntity = this.wixie.level.getBlockEntity(this.wixie.cauldronPos);
        this.found = false;
        if (tileEntity instanceof WixieCauldronTile) {
            WixieCauldronTile cauldronTile = (WixieCauldronTile)tileEntity;
            this.potionNeeded = cauldronTile.getNeededPotion();
            this.movePos = WixieCauldronTile.findNeededPotion(this.potionNeeded, 300, this.wixie.level, this.wixie.cauldronPos);
            this.startDistance = BlockUtil.distanceFrom(this.wixie.position, this.movePos);
        } else {
            this.found = true;
        }
        if (this.movePos == null) {
            this.found = true;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.found) {
            return;
        }
        if (this.movePos != null && BlockUtil.distanceFrom(this.wixie.position(), this.movePos.above()) < 2.0 + this.extendedRange) {
            WixieCauldronTile tile = (WixieCauldronTile)this.wixie.getCommandSenderWorld().getBlockEntity(this.wixie.cauldronPos);
            ServerLevel world = (ServerLevel)this.wixie.getCommandSenderWorld();
            if (tile == null) {
                this.found = true;
                return;
            }
            PotionJarTile jar = (PotionJarTile)world.getBlockEntity(this.movePos);
            if (jar == null) {
                this.found = true;
                return;
            }
            jar.remove(300);
            tile.givePotion();
            Networking.sendToNearbyClient((Level)world, (Entity)this.wixie, (CustomPacketPayload)new PacketAnimEntity(this.wixie.getId(), EntityWixie.Animations.SUMMON_ITEM.ordinal()));
            int color = jar.getColor();
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            EntityFollowProjectile.spawn(world, this.movePos, this.wixie.cauldronPos, r, g, b);
            this.found = true;
        }
        if (this.movePos != null && !this.found) {
            this.setPath(this.movePos.getX(), this.movePos.getY() + 1, this.movePos.getZ(), 1.2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canUse() {
        if (this.wixie.cauldronPos == null) {
            return false;
        }
        BlockEntity tileEntity = this.wixie.level.getBlockEntity(this.wixie.cauldronPos);
        if (this.wixie.inventoryBackoff != 0) return false;
        if (!(tileEntity instanceof WixieCauldronTile)) return false;
        WixieCauldronTile cauldronTile = (WixieCauldronTile)tileEntity;
        if (!cauldronTile.hasSource) return false;
        if (!cauldronTile.needsPotion()) return false;
        if (cauldronTile.isOff) return false;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.found;
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.wixie.getNavigation().moveTo(this.wixie.getNavigation().createPath(x + 0.5, y + 0.5, z + 0.5, 0), speedIn);
    }

    @Override
    public void stop() {
        super.stop();
        this.potionNeeded = PotionContents.EMPTY;
        this.found = false;
    }
}

