/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.Whirlisprig;
import com.hollingsworth.arsnouveau.common.entity.goal.DistanceRestrictedGoal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;

public class BonemealGoal
extends DistanceRestrictedGoal {
    private int timeGrowing;
    BlockPos growPos;
    Whirlisprig sylph;
    public final Predicate<BlockState> IS_GRASS = BlockStatePredicate.forBlock((Block)Blocks.GRASS_BLOCK);

    public BonemealGoal(Whirlisprig sylph) {
        super(() -> ((Whirlisprig)sylph).blockPosition(), 0);
        this.sylph = sylph;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public BonemealGoal(Whirlisprig sylph, Supplier<BlockPos> from, int distanceFrom) {
        super(from, distanceFrom);
        this.sylph = sylph;
    }

    public void stop() {
        this.timeGrowing = 0;
        this.growPos = null;
    }

    public void tick() {
        if (this.growPos == null) {
            return;
        }
        if (BlockUtil.distanceFrom(this.sylph.blockPosition(), this.growPos) > 1.2) {
            this.sylph.getNavigation().moveTo((double)this.growPos.getX(), (double)this.growPos.getY(), (double)this.growPos.getZ(), 1.2);
        } else {
            ServerLevel world = (ServerLevel)this.sylph.level;
            world.sendParticles((ParticleOptions)ParticleTypes.COMPOSTER, (double)this.growPos.getX() + 0.5, (double)this.growPos.getY() + 1.1, (double)this.growPos.getZ() + 0.5, 1, ParticleUtil.inRange(-0.2, 0.2), 0.0, ParticleUtil.inRange(-0.2, 0.2), 0.01);
            --this.timeGrowing;
            if (this.timeGrowing <= 0) {
                this.sylph.timeSinceBonemeal = 0;
                ItemStack stack = new ItemStack((ItemLike)Items.BONE_MEAL);
                BoneMealItem.applyBonemeal((ItemStack)stack, (Level)world, (BlockPos)this.growPos, (Player)ANFakePlayer.getPlayer(world));
            }
        }
    }

    public boolean canContinueToUse() {
        return this.timeGrowing > 0 && this.growPos != null && this.sylph.timeSinceBonemeal >= 9600 && this.isInRange(this.growPos);
    }

    public boolean canUse() {
        return this.sylph.level.random.nextInt(5) == 0 && this.sylph.timeSinceBonemeal >= 9600 && this.isInRange(this.sylph.blockPosition());
    }

    public void start() {
        Level world = this.sylph.level;
        int range = 4;
        if (this.IS_GRASS.test(world.getBlockState(this.sylph.blockPosition().below())) && world.getBlockState(this.sylph.blockPosition()).isAir()) {
            this.growPos = this.sylph.blockPosition().below();
        } else {
            ArrayList list = new ArrayList();
            BlockPos.betweenClosedStream((BlockPos)this.sylph.blockPosition().offset(range, range, range), (BlockPos)this.sylph.blockPosition().offset(-range, -range, -range)).forEach(bp -> {
                if (this.IS_GRASS.test(world.getBlockState(bp = bp.immutable())) && world.getBlockState(bp.above()).isAir()) {
                    list.add(bp);
                }
            });
            Collections.shuffle(list);
            if (!list.isEmpty()) {
                this.growPos = (BlockPos)list.get(0);
            }
        }
        this.timeGrowing = 60;
    }
}

