/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.event.EntityPreRemovalEvent;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BubbleEntity
extends Projectile
implements GeoEntity {
    int maxAge;
    int age;
    float damage;
    public int poppingTicks;
    public boolean hasPopped;
    List<UUID> hasDismounted = new ArrayList<UUID>();
    public static final EntityDataAccessor<Boolean> HAS_POPPED = SynchedEntityData.defineId(BubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BubbleEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BubbleEntity(Level pLevel, int maxAge, float damage) {
        super((EntityType)ModEntities.BUBBLE.get(), pLevel);
        this.maxAge = maxAge;
        this.damage = damage;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(HAS_POPPED, (Object)false);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public void tick() {
        super.tick();
        if (((Boolean)this.entityData.get(HAS_POPPED)).booleanValue()) {
            ++this.poppingTicks;
        }
        if (!this.level.isClientSide) {
            ++this.age;
            if (this.age > this.maxAge) {
                this.pop();
            }
            if (this.getPassengers().isEmpty()) {
                for (Entity entity1 : this.level.getEntities((Entity)this, this.getBoundingBox().inflate(0.5), this::canHitEntity)) {
                    entity1.startRiding((Entity)this);
                }
            }
        }
        if (this.poppingTicks > 5 && !this.level.isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.xOld = this.getX();
        this.yOld = this.getY();
        this.zOld = this.getZ();
        this.setDeltaMovement(ParticleUtil.inRange(-0.01, 0.01), 0.1, ParticleUtil.inRange(-0.01, 0.01));
        this.setPos(this.getNextHitPosition());
    }

    public boolean tryCapturing(Entity target) {
        if (!((Boolean)this.entityData.get(HAS_POPPED)).booleanValue() && this.getPassengers().isEmpty() && this.canHitEntity(target)) {
            target.startRiding((Entity)this);
            return !this.getPassengers().isEmpty();
        }
        return false;
    }

    public Vec3 getNextHitPosition() {
        return this.position().add(this.getDeltaMovement());
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        if (passenger != null && passenger.getUUID() != null) {
            this.hasDismounted.add(passenger.getUUID());
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    public void pop() {
        if (this.level.isClientSide) {
            return;
        }
        if (((Boolean)this.entityData.get(HAS_POPPED)).booleanValue()) {
            return;
        }
        this.entityData.set(HAS_POPPED, (Object)true);
        this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, this.getSoundSource(), 3.0f, 1.0f);
    }

    public static void onAttacked(AttackEntityEvent event) {
        Entity entity = event.getTarget();
        if (entity instanceof BubbleEntity) {
            BubbleEntity bubble = (BubbleEntity)entity;
            if (bubble.getPassengers().isEmpty() || bubble.getFirstPassenger() instanceof ItemEntity || bubble.getFirstPassenger() == event.getEntity()) {
                bubble.pop();
                event.setCanceled(true);
            } else {
                Entity entity2 = bubble.getFirstPassenger();
                if (entity2 instanceof LivingEntity) {
                    LivingEntity passenger = (LivingEntity)entity2;
                    event.getEntity().attack((Entity)passenger);
                }
            }
        }
    }

    public static void entityHurt(LivingDamageEvent.Pre e) {
        Entity entity = e.getEntity().getVehicle();
        if (entity instanceof BubbleEntity) {
            BubbleEntity bubble = (BubbleEntity)entity;
            if (bubble.age > 1 && !bubble.hasPopped && bubble.getFirstPassenger() != bubble.getOwner()) {
                float damage = bubble.damage;
                Entity owner = bubble.getOwner();
                if (owner instanceof LivingEntity) {
                    LivingEntity shooter = (LivingEntity)owner;
                    damage += shooter.getAttributes().hasAttribute(PerkAttributes.SPELL_DAMAGE_BONUS) ? (float)shooter.getAttributeValue(PerkAttributes.SPELL_DAMAGE_BONUS) : 0.0f;
                }
                e.setNewDamage(e.getNewDamage() + damage);
            }
            bubble.pop();
        }
    }

    public static void preEntityRemoval(EntityPreRemovalEvent event) {
        Entity entity = event.getEntity().getVehicle();
        if (entity instanceof BubbleEntity) {
            BubbleEntity bubble = (BubbleEntity)entity;
            bubble.getEntityData().set(HAS_POPPED, (Object)true);
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
        this.tryCapturing(pResult.getEntity());
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.getPassengers().isEmpty() || this.getFirstPassenger() instanceof ItemEntity) {
            this.pop();
        }
        return true;
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    protected boolean canHitEntity(Entity pTarget) {
        if (pTarget != null && pTarget.getUUID() != null && this.hasDismounted.contains(pTarget.getUUID())) {
            return false;
        }
        return !pTarget.getType().is(EntityTags.BUBBLE_BLACKLIST) && !(pTarget.getVehicle() instanceof BubbleEntity);
    }

    public Vec3 getPassengerRidingPosition(Entity pEntity) {
        return pEntity instanceof ItemEntity ? this.position.add(0.0, 0.25, 0.0) : this.position;
    }

    protected boolean canRide(Entity pVehicle) {
        return !(pVehicle instanceof BubbleEntity) && super.canRide(pVehicle);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean save(CompoundTag pCompound) {
        pCompound.putInt("maxAge", this.maxAge);
        pCompound.putFloat("damage", this.damage);
        pCompound.putInt("age", this.age);
        return super.save(pCompound);
    }

    public void load(CompoundTag pCompound) {
        super.load(pCompound);
        this.maxAge = pCompound.getInt("maxAge");
        this.damage = pCompound.getFloat("damage");
        this.age = pCompound.getInt("age");
    }

    public boolean canBeHitByProjectile() {
        return this.getPassengers().isEmpty() || this.getFirstPassenger() instanceof ItemEntity && this.isAlive() && this.age > 1;
    }

    public boolean mayInteract(Level pLevel, BlockPos pPos) {
        return true;
    }
}

