/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.capability;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.capability.FamiliarData;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class ANPlayerData
implements INBTSerializable<CompoundTag> {
    public Set<AbstractSpellPart> glyphs = new HashSet<AbstractSpellPart>();
    public Set<FamiliarData> familiars = new HashSet<FamiliarData>();
    public ResourceLocation lastSummonedFamiliar;

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        CompoundTag glyphsTag = new CompoundTag();
        List glyphsList = this.glyphs.stream().toList();
        for (int i = 0; i < glyphsList.size(); ++i) {
            glyphsTag.putString("glyph" + i, ((AbstractSpellPart)glyphsList.get(i)).getRegistryName().toString());
        }
        glyphsTag.putInt("size", glyphsList.size());
        tag.put("glyphs", (Tag)glyphsTag);
        CompoundTag familiarsTag = new CompoundTag();
        List familiarsList = this.familiars.stream().toList();
        for (int i = 0; i < familiarsList.size(); ++i) {
            familiarsTag.put("familiar" + i, (Tag)((FamiliarData)familiarsList.get(i)).toTag());
        }
        familiarsTag.putInt("size", familiarsList.size());
        tag.put("familiars", (Tag)familiarsTag);
        if (this.lastSummonedFamiliar != null) {
            tag.putString("lastSummonedFamiliar", this.lastSummonedFamiliar.toString());
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.glyphs = new HashSet<AbstractSpellPart>();
        this.familiars = new HashSet<FamiliarData>();
        CompoundTag glyphsTag = nbt.getCompound("glyphs");
        for (int i = 0; i < glyphsTag.getInt("size"); ++i) {
            ResourceLocation id = ResourceLocation.parse((String)glyphsTag.getString("glyph" + i));
            AbstractSpellPart part = GlyphRegistry.getSpellPart(id);
            if (part == null) continue;
            this.glyphs.add(part);
        }
        CompoundTag familiarsTag = nbt.getCompound("familiars");
        for (int i = 0; i < familiarsTag.getInt("size"); ++i) {
            this.familiars.add(new FamiliarData(familiarsTag.getCompound("familiar" + i)));
        }
        if (nbt.contains("lastSummonedFamiliar")) {
            this.lastSummonedFamiliar = ResourceLocation.parse((String)nbt.getString("lastSummonedFamiliar"));
        }
    }
}

