/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.documentation;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.nuggets.client.gui.NuggetImageButton;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class BookmarkButton
extends NuggetImageButton {
    DocEntry entry;

    public BookmarkButton(int x, int y, DocEntry entry, Button.OnPress onPress) {
        super(x, y, DocAssets.BOOKMARK.width(), DocAssets.BOOKMARK.height(), DocAssets.BOOKMARK.location(), onPress);
        this.entry = entry;
    }

    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderWidget(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.entry != null) {
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)(this.x - 1), (float)this.y - 1.5f, 0.0f);
            RenderUtils.drawItemAsIcon(this.entry.renderStack(), graphics, 0, 0, 8, false);
            poseStack.popPose();
        }
    }

    public void gatherTooltips(List<Component> tooltip) {
        super.gatherTooltips(tooltip);
        if (this.entry != null) {
            tooltip.add(this.entry.entryTitle());
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.shift_delete").withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        }
    }
}

