/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class QuickMover {
    private final MoveFunction moveFunc;
    private final List<MoveAttempt> attempts;
    private int after = -1;

    public QuickMover(MoveFunction moveFunc) {
        this.moveFunc = moveFunc;
        this.attempts = new ArrayList<MoveAttempt>();
    }

    public QuickMover add(MoveCondition condition, int start, int slots) {
        this.attempts.add(new MoveAttempt(condition, this.after, start, slots));
        return this;
    }

    public QuickMover fallback(int start, int slots) {
        this.attempts.add(new MoveAttempt((slot, stack, player) -> true, -1, start, slots));
        return this;
    }

    public QuickMover after(int slot) {
        this.after = slot;
        return this;
    }

    public boolean run(int slot, ItemStack stack, Player player) {
        for (MoveAttempt attempt : this.attempts) {
            if (slot < attempt.minSlot || !attempt.condition.apply(slot, stack, player) || this.moveFunc.apply(stack, attempt.start, attempt.end(), attempt.inverse)) continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public boolean apply(ItemStack var1, int var2, int var3, boolean var4);
    }

    private record MoveAttempt(MoveCondition condition, int minSlot, int start, int slots, boolean inverse) {
        MoveAttempt(MoveCondition condition, int minSlot, int start, int slots) {
            this(condition, minSlot, start, slots, false);
        }

        public int end() {
            return this.start + this.slots;
        }
    }

    @FunctionalInterface
    public static interface MoveCondition {
        public boolean apply(int var1, ItemStack var2, Player var3);
    }
}

