/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.client.sound;

import com.blakebr0.cucumber.init.ModSounds;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class WateringCanSound
extends AbstractTickableSoundInstance {
    private static final Map<Integer, WateringCanSound> PLAYING_FOR = Collections.synchronizedMap(new HashMap());
    private final Player player;
    private final ItemStack useItem;
    private final ItemStack selectedItem;

    public WateringCanSound(Player player) {
        super((SoundEvent)ModSounds.WATERING_CAN.get(), SoundSource.PLAYERS, player.getRandom());
        this.player = player;
        this.useItem = player.getUseItem();
        this.selectedItem = player.getInventory().getSelected();
        this.looping = true;
        this.volume = 0.5f;
        PLAYING_FOR.put(player.getId(), this);
    }

    public static boolean playing(int entityId) {
        return PLAYING_FOR.containsKey(entityId) && PLAYING_FOR.get(entityId) != null && !PLAYING_FOR.get(entityId).isStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(int entityId) {
        Map<Integer, WateringCanSound> map = PLAYING_FOR;
        synchronized (map) {
            WateringCanSound sound = PLAYING_FOR.remove(entityId);
            if (sound != null) {
                sound.stop();
            }
        }
    }

    public boolean canPlaySound() {
        WateringCanSound instance = PLAYING_FOR.get(this.player.getId());
        return instance == null || instance == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Map<Integer, WateringCanSound> map;
        Vec3 pos = this.player.position();
        this.x = (float)pos.x();
        this.y = (float)pos.y() - 10.0f;
        this.z = (float)pos.z();
        if (!this.useItem.isEmpty() && this.player.getUseItem() != this.useItem) {
            map = PLAYING_FOR;
            synchronized (map) {
                PLAYING_FOR.remove(this.player.getId());
                this.stop();
            }
        }
        if (this.player.getInventory().getSelected() != this.selectedItem) {
            map = PLAYING_FOR;
            synchronized (map) {
                PLAYING_FOR.remove(this.player.getId());
                this.stop();
            }
        }
    }
}

