/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib;

import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.me.helpers.PlayerSource;
import de.mari_023.ae2wtlib.api.AE2wtlibComponents;
import de.mari_023.ae2wtlib.api.AE2wtlibTags;
import de.mari_023.ae2wtlib.networking.PickBlockPacket;
import de.mari_023.ae2wtlib.networking.UpdateRestockPacket;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class AE2wtlibEvents {
    public static void restock(ServerPlayer player, ItemStack item, int count, Consumer<ItemStack> setStack) {
        if (player.isCreative()) {
            return;
        }
        if (item.isEmpty()) {
            return;
        }
        if (item.is(AE2wtlibTags.NO_RESTOCK)) {
            return;
        }
        CraftingTerminalHandler cTHandler = CraftingTerminalHandler.getCraftingTerminalHandler((Player)player);
        if (!cTHandler.inRange()) {
            return;
        }
        ItemStack hostItem = cTHandler.getCraftingTerminal();
        if (!((Boolean)hostItem.getOrDefault(AE2wtlibComponents.RESTOCK, (Object)false)).booleanValue()) {
            return;
        }
        if (cTHandler.getTargetGrid() == null) {
            return;
        }
        if (cTHandler.getTargetGrid().getStorageService() == null) {
            return;
        }
        int toAdd = Math.max(item.getMaxStackSize() / 2, 1) - count;
        if (toAdd == 0) {
            return;
        }
        long changed = toAdd > 0 ? cTHandler.getTargetGrid().getStorageService().getInventory().extract((AEKey)AEItemKey.of((ItemStack)item), (long)toAdd, Actionable.MODULATE, (IActionSource)new PlayerSource((Player)player)) : -cTHandler.getTargetGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)item), (long)(-toAdd), Actionable.MODULATE, (IActionSource)new PlayerSource((Player)player));
        item.setCount(count + (int)changed);
        setStack.accept(item);
        int slot = player.getInventory().findSlotMatchingUnusedItem(item);
        if (slot == -1 && player.getInventory().offhand.contains((Object)item)) {
            slot = 36;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdateRestockPacket(slot, item.getCount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void insertStackInME(ItemEntity entity, Player player) {
        ItemStack stack = entity.getItem();
        if (stack.isEmpty()) {
            return;
        }
        if (player.level().isClientSide()) {
            return;
        }
        if (player.isShiftKeyDown()) {
            return;
        }
        CraftingTerminalHandler cTHandler = CraftingTerminalHandler.getCraftingTerminalHandler(player);
        ItemStack terminal = cTHandler.getCraftingTerminal();
        if (!MagnetHandler.getMagnetMode(terminal).pickupToME()) {
            return;
        }
        if (!cTHandler.inRange()) {
            return;
        }
        MagnetHost magnetHost = cTHandler.getMagnetHost();
        if (magnetHost == null) {
            return;
        }
        if (magnetHost.getInsertFilter().isEmpty() && magnetHost.getInsertMode() == IncludeExclude.WHITELIST) {
            return;
        }
        if (!magnetHost.getInsertFilter().matchesFilter((AEKey)AEItemKey.of((ItemStack)stack), magnetHost.getInsertMode())) {
            return;
        }
        if (cTHandler.getTargetGrid() == null) {
            return;
        }
        if (cTHandler.getTargetGrid().getStorageService() == null) {
            return;
        }
        long inserted = cTHandler.getTargetGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.getCount(), Actionable.MODULATE, (IActionSource)new PlayerSource(player));
        int leftover = (int)((long)stack.getCount() - inserted);
        player.awardStat(Stats.ITEM_PICKED_UP.get((Object)stack.getItem()), (int)inserted);
        player.onItemPickup(entity);
        stack.setCount(leftover);
    }

    public static void pickBlock(ItemStack stack) {
        PacketDistributor.sendToServer((CustomPacketPayload)new PickBlockPacket(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void pickBlock(ServerPlayer player, ItemStack stack) {
        long extracted;
        int targetSlot;
        CraftingTerminalHandler cTHandler = CraftingTerminalHandler.getCraftingTerminalHandler((Player)player);
        ItemStack terminal = cTHandler.getCraftingTerminal();
        if (!((Boolean)terminal.getOrDefault(AE2wtlibComponents.PICK_BLOCK, (Object)false)).booleanValue()) {
            return;
        }
        if (cTHandler.getTargetGrid() == null) {
            return;
        }
        if (cTHandler.getTargetGrid().getStorageService() == null) {
            return;
        }
        MEStorage networkInventory = cTHandler.getTargetGrid().getStorageService().getInventory();
        PlayerSource playerSource = new PlayerSource((Player)player);
        Inventory inventory = player.getInventory();
        ItemStack toReplace = inventory.getItem(targetSlot = inventory.getSuitableHotbarSlot());
        long insert = networkInventory.insert((AEKey)AEItemKey.of((ItemStack)toReplace), (long)toReplace.getCount(), Actionable.SIMULATE, (IActionSource)playerSource);
        if (insert < (long)toReplace.getCount()) {
            return;
        }
        int targetAmount = stack.getMaxStackSize();
        if (!stack.is(AE2wtlibTags.NO_RESTOCK) && targetAmount != 1) {
            targetAmount /= 2;
        }
        if ((extracted = networkInventory.extract((AEKey)AEItemKey.of((ItemStack)stack), (long)targetAmount, Actionable.SIMULATE, (IActionSource)playerSource)) == 0L) {
            return;
        }
        insert = networkInventory.insert((AEKey)AEItemKey.of((ItemStack)toReplace), (long)toReplace.getCount(), Actionable.MODULATE, (IActionSource)playerSource);
        if (insert < (long)toReplace.getCount()) {
            toReplace.setCount(toReplace.getCount() - (int)insert);
            inventory.setItem(targetSlot, toReplace);
            return;
        }
        extracted = networkInventory.extract((AEKey)AEItemKey.of((ItemStack)stack), (long)targetAmount, Actionable.MODULATE, (IActionSource)playerSource);
        if (extracted == 0L) {
            inventory.setItem(targetSlot, ItemStack.EMPTY);
            return;
        }
        stack.setCount((int)extracted);
        inventory.setItem(targetSlot, stack);
        inventory.selected = targetSlot;
        player.connection.send((Packet)new ClientboundSetCarriedItemPacket(player.getInventory().selected));
    }
}

