/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.fluids;

import blusunrize.immersiveengineering.common.fluids.IEFluidBlock;
import blusunrize.immersiveengineering.common.register.IEFluids;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;

public class IEFluid
extends FlowingFluid {
    private static IEFluids.FluidEntry entryStatic;
    protected final IEFluids.FluidEntry entry;
    public static final DispenseItemBehavior BUCKET_DISPENSE_BEHAVIOR;

    public static IEFluid makeFluid(Function<IEFluids.FluidEntry, ? extends IEFluid> make, IEFluids.FluidEntry entry) {
        entryStatic = entry;
        IEFluid result = make.apply(entry);
        entryStatic = null;
        return result;
    }

    public IEFluid(IEFluids.FluidEntry entry) {
        this.entry = entry;
    }

    @Nonnull
    public Item getBucket() {
        return this.entry.getBucket();
    }

    protected boolean canBeReplacedWith(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluidIn, Direction direction) {
        return direction == Direction.DOWN && !this.isSame(fluidIn);
    }

    public boolean isSame(@Nonnull Fluid fluidIn) {
        return fluidIn == this.entry.getStill() || fluidIn == this.entry.getFlowing();
    }

    public int getTickDelay(LevelReader p_205569_1_) {
        int dW = this.getFlowing().getFluidType().getViscosity() - Fluids.WATER.getFluidType().getViscosity();
        double v = Math.round(5.0 + (double)dW * 0.005);
        return Math.max(2, (int)v);
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
        super.createFluidStateDefinition(builder);
        for (Property<?> p : (this.entry == null ? entryStatic : this.entry).properties()) {
            builder.add(new Property[]{p});
        }
    }

    protected BlockState createLegacyBlock(FluidState state) {
        BlockState result = (BlockState)this.entry.getBlock().defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(IEFluid.getLegacyLevel((FluidState)state)));
        for (Property<?> prop : this.entry.properties()) {
            result = IEFluidBlock.withCopiedValue(prop, result, state);
        }
        return result;
    }

    public boolean isSource(FluidState state) {
        return state.getType() == this.entry.getStill();
    }

    public int getAmount(FluidState state) {
        if (this.isSource(state)) {
            return 8;
        }
        return (Integer)state.getValue((Property)LEVEL);
    }

    public FluidType getFluidType() {
        return (FluidType)this.entry.type().value();
    }

    @Nonnull
    public Fluid getFlowing() {
        return this.entry.getFlowing();
    }

    @Nonnull
    public Fluid getSource() {
        return this.entry.getStill();
    }

    public boolean canConvertToSource(Level level) {
        return false;
    }

    protected void beforeDestroyingBlock(LevelAccessor iWorld, BlockPos blockPos, BlockState blockState) {
    }

    protected int getSlopeFindDistance(LevelReader iWorldReader) {
        return 4;
    }

    protected int getDropOff(LevelReader iWorldReader) {
        return 1;
    }

    public static Consumer<FluidType.Properties> createBuilder(int density, int viscosity) {
        return builder -> builder.viscosity(viscosity).density(density);
    }

    static {
        BUCKET_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource source, ItemStack stack) {
                BucketItem bucketitem = (BucketItem)stack.getItem();
                BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel world = source.level();
                if (bucketitem.emptyContents(null, (Level)world, blockpos, null)) {
                    bucketitem.checkExtraContent(null, (Level)world, stack, blockpos);
                    return new ItemStack((ItemLike)Items.BUCKET);
                }
                return this.defaultBehavior.dispense(source, stack);
            }
        };
    }

    public static class EntityFluidSerializer
    implements EntityDataSerializer<FluidStack> {
        public StreamCodec<? super RegistryFriendlyByteBuf, FluidStack> codec() {
            return FluidStack.STREAM_CODEC;
        }

        @Nonnull
        public FluidStack copy(FluidStack value) {
            return value.copy();
        }
    }

    public static class Flowing
    extends IEFluid {
        public Flowing(IEFluids.FluidEntry entry) {
            super(entry);
        }

        @Override
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }
    }
}

