/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorType;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.client.render.conveyor.SplitConveyorRender;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBase;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class SplitConveyor
extends ConveyorBase {
    public static final ResourceLocation NAME = ImmersiveEngineering.rl("splitter");
    public static final ResourceLocation texture_on = ImmersiveEngineering.rl("block/conveyor/split");
    public static final ResourceLocation texture_off = ImmersiveEngineering.rl("block/conveyor/split_off");
    public static final IConveyorType<SplitConveyor> TYPE = new BasicConveyorType<SplitConveyor>(NAME, false, true, SplitConveyor::new, () -> new SplitConveyorRender(texture_on, texture_off));
    boolean nextOutputLeft = true;

    public SplitConveyor(BlockEntity tile) {
        super(tile);
    }

    public IConveyorType<SplitConveyor> getType() {
        return TYPE;
    }

    @Override
    public ConveyorHandler.ConveyorDirection getConveyorDirection() {
        return ConveyorHandler.ConveyorDirection.HORIZONTAL;
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    public void handleInsertion(ItemEntity entity, ConveyorHandler.ConveyorDirection conDir, double distX, double distZ) {
        String nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getBlockEntity().getBlockPos().hashCode());
        if (entity.getPersistentData().contains(nbtKey, 3)) {
            Direction redirect = Direction.values()[entity.getPersistentData().getInt(nbtKey)];
            BlockPos nextPos = this.getBlockEntity().getBlockPos().relative(redirect);
            double distNext = Math.abs((double)(redirect.getAxis() == Direction.Axis.Z ? nextPos.getZ() : nextPos.getX()) + 0.5 - (redirect.getAxis() == Direction.Axis.Z ? entity.getZ() : entity.getX()));
            BlockEntity inventoryTile = this.getBlockEntity().getLevel().getBlockEntity(nextPos);
            if (distNext < 0.7 && inventoryTile != null && !(inventoryTile instanceof ConveyorHandler.IConveyorBlockEntity)) {
                ItemUtils.tryInsertEntity(this.getBlockEntity().getLevel(), this.getBlockEntity().getBlockPos().relative(redirect), redirect.getOpposite(), entity);
            }
        }
    }

    @Override
    public void onEntityCollision(@Nonnull Entity entity) {
        BlockPos nextPos;
        String nbtKey;
        if (!this.isActive()) {
            return;
        }
        Direction redirect = null;
        if (entity.isAlive()) {
            nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getBlockEntity().getBlockPos().hashCode());
            if (entity.getPersistentData().contains(nbtKey, 3)) {
                redirect = Direction.values()[entity.getPersistentData().getInt(nbtKey)];
            } else {
                redirect = this.getOutputFace();
                entity.getPersistentData().putInt(nbtKey, redirect.ordinal());
                nextPos = this.getBlockEntity().getBlockPos().relative(this.getOutputFace().getOpposite());
                if (this.getBlockEntity().getLevel().hasChunkAt(nextPos)) {
                    BlockEntity nextTile = this.getBlockEntity().getLevel().getBlockEntity(nextPos);
                    if (!(nextTile instanceof ConveyorHandler.IConveyorBlockEntity)) {
                        this.nextOutputLeft = !this.nextOutputLeft;
                    } else if (((ConveyorHandler.IConveyorBlockEntity)nextTile).getFacing() != this.getOutputFace()) {
                        this.nextOutputLeft = !this.nextOutputLeft;
                    }
                }
            }
        }
        super.onEntityCollision(entity);
        if (redirect != null) {
            boolean contact;
            nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getBlockEntity().getBlockPos().hashCode());
            nextPos = this.getBlockEntity().getBlockPos().relative(redirect);
            double distNext = Math.abs((double)(redirect.getAxis() == Direction.Axis.Z ? nextPos.getZ() : nextPos.getX()) + 0.5 - (redirect.getAxis() == Direction.Axis.Z ? entity.getZ() : entity.getX()));
            double treshold = 0.4;
            boolean bl = contact = distNext < treshold;
            if (contact) {
                entity.getPersistentData().remove(nbtKey);
            }
        }
    }

    @Override
    public Direction[] sigTransportDirections() {
        return new Direction[]{this.getFacing().getClockWise(), this.getFacing().getCounterClockWise()};
    }

    @Override
    public Vec3 getDirection(Entity entity, boolean outputBlocked) {
        Vec3 vec = super.getDirection(entity, outputBlocked);
        String nbtKey = "immersiveengineering:conveyorDir" + Integer.toHexString(this.getBlockEntity().getBlockPos().hashCode());
        if (!entity.getPersistentData().contains(nbtKey, 3)) {
            return vec;
        }
        Direction redirect = Direction.from3DDataValue((int)entity.getPersistentData().getInt(nbtKey));
        BlockPos wallPos = this.getBlockEntity().getBlockPos().relative(this.getFacing());
        double distNext = Math.abs((double)(this.getFacing().getAxis() == Direction.Axis.Z ? wallPos.getZ() : wallPos.getX()) + 0.5 - (this.getFacing().getAxis() == Direction.Axis.Z ? entity.getZ() : entity.getX()));
        if (distNext < 1.33) {
            double sideMove = Math.pow(1.0 + distNext, 0.1) * 0.2;
            if (distNext < 0.8) {
                vec = new Vec3(this.getFacing().getAxis() == Direction.Axis.X ? 0.0 : vec.x, vec.y, this.getFacing().getAxis() == Direction.Axis.Z ? 0.0 : vec.z);
            }
            vec = vec.add((double)redirect.getStepX() * sideMove, 0.0, (double)redirect.getStepZ() * sideMove);
        }
        return vec;
    }

    @Override
    public CompoundTag writeConveyorNBT() {
        CompoundTag nbt = super.writeConveyorNBT();
        nbt.putBoolean("nextLeft", this.nextOutputLeft);
        return nbt;
    }

    @Override
    public void readConveyorNBT(CompoundTag nbt) {
        super.readConveyorNBT(nbt);
        this.nextOutputLeft = nbt.getBoolean("nextLeft");
    }

    @Override
    public List<BlockPos> getNextConveyorCandidates() {
        BlockPos baseOutput = this.getBlockEntity().getBlockPos().relative(this.getOutputFace());
        return ImmutableList.of((Object)baseOutput, (Object)baseOutput.below());
    }

    @Override
    public boolean isOutputBlocked() {
        Direction outputFace = this.getOutputFace();
        BlockPos here = this.getBlockEntity().getBlockPos();
        for (BlockPos outputPos : new BlockPos[]{here.relative(outputFace, 1), here.relative(outputFace, -1)}) {
            BlockEntity tile = SafeChunkUtils.getSafeBE((LevelAccessor)this.getBlockEntity().getLevel(), outputPos);
            if (!(tile instanceof ConveyorHandler.IConveyorBlockEntity) || !((ConveyorHandler.IConveyorBlockEntity)tile).getConveyorInstance().isBlocked()) continue;
            return true;
        }
        return false;
    }

    private Direction getOutputFace() {
        if (this.nextOutputLeft) {
            return this.getFacing().getCounterClockWise();
        }
        return this.getFacing().getClockWise();
    }
}

