/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallback;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.utils.Color4;
import java.util.function.BiFunction;

public class MaterialColorGetter<T>
implements BiFunction<String, Color4, Color4> {
    private final String groupName;
    private final IEOBJCallback<T> callback;
    private final T callbackObject;
    private final ShaderCase shaderCase;
    private int renderPass = 0;

    public MaterialColorGetter(String groupName, IEOBJCallback<T> callback, T callbackObject, ShaderCase shaderCase) {
        this.groupName = groupName;
        this.callback = callback;
        this.callbackObject = callbackObject;
        this.shaderCase = shaderCase;
    }

    public void setRenderPass(int pass) {
        this.renderPass = pass;
    }

    @Override
    public Color4 apply(String material, Color4 originalColor) {
        Color4 color = originalColor;
        if (this.callback != null) {
            color = this.callback.getRenderColor(this.callbackObject, this.groupName, material, this.shaderCase, color);
        }
        if (this.shaderCase != null) {
            color = this.shaderCase.getRenderColor(this.groupName, this.renderPass, color);
        }
        return color;
    }
}

