/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public class CapabilityShader {
    public static final ItemCapability<ShaderWrapper, Void> ITEM = ItemCapability.createVoid((ResourceLocation)IEApi.ieLoc("shader_item"), ShaderWrapper.class);
    public static final BlockCapability<ShaderWrapper, Void> BLOCK = BlockCapability.createVoid((ResourceLocation)IEApi.ieLoc("shader_block"), ShaderWrapper.class);
    public static ModelProperty<ShaderCase> MODEL_PROPERTY = new ModelProperty();

    public static boolean shouldReequipDueToShader(ItemStack oldStack, ItemStack newStack) {
        ShaderWrapper wrapperOld = (ShaderWrapper)oldStack.getCapability(ITEM);
        ShaderWrapper wrapperNew = (ShaderWrapper)newStack.getCapability(ITEM);
        if (wrapperOld == null && wrapperNew != null) {
            return true;
        }
        if (wrapperOld != null && wrapperNew == null) {
            return true;
        }
        if (wrapperOld != null) {
            return !Objects.equals(wrapperOld.getShader(), wrapperNew.getShader());
        }
        return false;
    }

    public static interface ShaderWrapper {
        public ResourceLocation getShaderType();

        public void setShader(@Nullable ResourceLocation var1);

        @Nullable
        public ResourceLocation getShader();

        default public ShaderCase getCase() {
            ResourceLocation shaderStack = this.getShader();
            if (shaderStack != null) {
                return ShaderRegistry.getShader(shaderStack, this.getShaderType());
            }
            return null;
        }
    }

    public static final class WrapperSerializer
    implements IAttachmentSerializer<CompoundTag, ShaderWrapper_Direct> {
        public CompoundTag write(ShaderWrapper_Direct attachment, HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            ResourceLocation shader = attachment.getShader();
            if (shader != null) {
                nbt.putString("IE:Shader", shader.toString());
            } else {
                nbt.putString("IE:NoShader", "");
            }
            nbt.putString("IE:ShaderType", attachment.getShaderType().toString());
            return nbt;
        }

        public ShaderWrapper_Direct read(IAttachmentHolder holder, CompoundTag tag, HolderLookup.Provider provider) {
            ShaderWrapper_Direct wrapper = new ShaderWrapper_Direct(ResourceLocation.parse((String)tag.getString("IE:ShaderType")));
            if (!tag.contains("IE:NoShader")) {
                wrapper.setShader(ResourceLocation.parse((String)tag.getString("IE:Shader")));
            }
            return wrapper;
        }
    }

    public static class ShaderWrapper_Direct
    implements ShaderWrapper {
        public static final IAttachmentSerializer<CompoundTag, ShaderWrapper_Direct> SERIALIZER = new WrapperSerializer();
        @Nullable
        private ResourceLocation shader = null;
        private final ResourceLocation type;

        public ShaderWrapper_Direct(ResourceLocation type) {
            this.type = type;
        }

        @Override
        public ResourceLocation getShaderType() {
            return this.type;
        }

        @Override
        public void setShader(@Nullable ResourceLocation shader) {
            this.shader = shader;
        }

        @Override
        @Nullable
        public ResourceLocation getShader() {
            return this.shader;
        }
    }

    public static class ShaderWrapper_Item
    implements ShaderWrapper {
        private final ItemStack container;
        private final ResourceLocation shaderType;

        public ShaderWrapper_Item(ResourceLocation type, ItemStack container) {
            this.shaderType = type;
            this.container = container;
        }

        @Override
        public ResourceLocation getShaderType() {
            return this.shaderType;
        }

        @Override
        public void setShader(@Nullable ResourceLocation shader) {
            if (shader != null) {
                this.container.set(IEApiDataComponents.ATTACHED_SHADER, (Object)shader);
            } else {
                this.container.remove(IEApiDataComponents.ATTACHED_SHADER);
            }
        }

        @Override
        @Nullable
        public ResourceLocation getShader() {
            return (ResourceLocation)this.container.get(IEApiDataComponents.ATTACHED_SHADER);
        }
    }
}

