/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.item.ILeftClickReact;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.components.LunchBaskedContent;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.mixins.LivingEntityAccessor;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LunchBoxItem
extends SelectableContainerItem<LunchBaskedContent, LunchBaskedContent.Mutable>
implements ILeftClickReact {
    public LunchBoxItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (MiscUtils.showsHints(tooltipFlag)) {
            LunchBoxItem.addClientTooltip(tooltipComponents);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addClientTooltip(List<Component> list) {
        list.add((Component)Component.translatable((String)"message.supplementaries.lunch_box.tooltip", (Object[])new Object[]{Minecraft.getInstance().options.keyAttack.getTranslatedKeyMessage()}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        VibeChecker.assertSameLevel(level, player);
        ItemStack basket = player.getItemInHand(hand);
        LunchBaskedContent data = (LunchBaskedContent)basket.get(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            ItemStack food = data.getSelected();
            if (food.isEmpty()) {
                return InteractionResultHolder.fail((Object)basket);
            }
            player.setItemInHand(hand, food);
            InteractionResultHolder result = food.use(level, player, hand);
            ItemStack resItem = (ItemStack)result.getObject();
            LunchBaskedContent.Mutable mutable = data.toMutable();
            boolean success = LunchBoxItem.swapWithSelected((LivingEntity)player, resItem, mutable, food);
            if (success) {
                basket.set(this.getComponentType(), (Object)mutable.toImmutable());
            }
            ((LivingEntityAccessor)player).setUseItem(basket);
            player.setItemInHand(hand, basket);
            return new InteractionResultHolder(result.getResult(), (Object)basket);
        }
        return super.use(level, player, hand);
    }

    public boolean onLeftClick(ItemStack stack, Player player, InteractionHand hand) {
        LunchBaskedContent data = (LunchBaskedContent)stack.get(this.getComponentType());
        if (data == null) {
            return false;
        }
        boolean open = data.canEatFrom();
        if (open) {
            player.playSound(ModSounds.LUNCH_BASKET_CLOSE.get(), 0.3f, 1.0f + player.level().getRandom().nextFloat() * 0.3f);
        } else {
            player.playSound(ModSounds.LUNCH_BASKET_OPEN.get(), 0.3f, 1.6f + player.level().getRandom().nextFloat() * 0.3f);
        }
        LunchBaskedContent.Mutable mutable = data.toMutable();
        mutable.switchMode();
        stack.set(this.getComponentType(), (Object)mutable.toImmutable());
        return true;
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        LunchBaskedContent data = (LunchBaskedContent)stack.get(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            return SuppPlatformStuff.getFoodProperties(data.getSelected(), entity);
        }
        return null;
    }

    public boolean allowComponentsUpdateAnimation(Player player, InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        return false;
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        LunchBaskedContent data = (LunchBaskedContent)stack.get(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            return data.getSelected().getUseDuration(livingEntity);
        }
        return super.getUseDuration(stack, livingEntity);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        LunchBaskedContent data = (LunchBaskedContent)stack.get(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            return data.getSelected().getUseAnimation();
        }
        return super.getUseAnimation(stack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        LunchBaskedContent data = (LunchBaskedContent)stack.get(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            LunchBaskedContent.Mutable mutable = data.toMutable();
            ItemStack selected = data.getSelected();
            ItemStack copy = selected.copyWithCount(1);
            ItemStack result = SuppPlatformStuff.finishUsingItem(copy, level, livingEntity);
            boolean success = LunchBoxItem.swapWithSelected(livingEntity, result, mutable, selected);
            if (success) {
                stack.set(this.getComponentType(), (Object)mutable.toImmutable());
            }
            return stack;
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        LunchBaskedContent data = (LunchBaskedContent)stack.get(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            ItemStack selected = data.getSelected();
            SuppPlatformStuff.releaseUsingItem(selected, entity);
        }
    }

    private static boolean swapWithSelected(LivingEntity livingEntity, ItemStack result, LunchBaskedContent.Mutable data, ItemStack currentStack) {
        boolean success = false;
        if (result.isEmpty()) {
            data.getSelected().shrink(1);
            success = true;
        } else if (!ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)currentStack)) {
            Player p;
            data.getSelected().shrink(1);
            ItemStack remaining = data.tryAdding(result);
            success = true;
            if (!remaining.isEmpty() && livingEntity instanceof Player && !(p = (Player)livingEntity).getInventory().add(remaining)) {
                p.drop(remaining, false);
            }
        }
        return success;
    }

    @Override
    protected void playInsertSound(Entity pEntity) {
        pEntity.playSound(ModSounds.LUNCH_BASKET_INSERT.get(), 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    @Override
    public DataComponentType<LunchBaskedContent> getComponentType() {
        return ModComponents.LUNCH_BASKET_CONTENT.get();
    }

    @Override
    public int getMaxSlots() {
        return CommonConfigs.Tools.LUNCH_BOX_SLOTS.get();
    }

    @NotNull
    public static ItemStack findActiveLunchBox(LivingEntity entity) {
        return LunchBoxItem.findActiveLunchBoxSlot(entity).get(entity);
    }

    @NotNull
    public static SlotReference findActiveLunchBoxSlot(LivingEntity entity) {
        return SuppPlatformStuff.getFirstInInventory(entity, i -> i.getItem() instanceof LunchBoxItem);
    }

    public static boolean canAcceptItem(ItemStack toInsert) {
        if (!toInsert.getItem().canFitInsideContainerItems()) {
            return false;
        }
        if (toInsert.is(ModTags.LUNCH_BASKET_BLACKLIST)) {
            return false;
        }
        UseAnim animation = toInsert.getItem().getUseAnimation(toInsert);
        return animation == UseAnim.DRINK || animation == UseAnim.EAT;
    }
}

