/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.common.entities.HatStandEntity;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HatStandItem
extends Item {
    public HatStandItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction direction = context.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPlaceContext placeContext = new BlockPlaceContext(context);
        BlockPos blockpos = placeContext.getClickedPos();
        if (placeContext.canPlace()) {
            EntityType<HatStandEntity> type = ModEntities.HAT_STAND.get();
            Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)blockpos);
            AABB aABB = type.getDimensions().makeBoundingBox(vec3.x(), vec3.y(), vec3.z());
            if (level.noCollision(null, aABB) && level.getEntities(null, aABB).isEmpty()) {
                ItemStack itemstack = context.getItemInHand();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    level.removeBlock(blockpos, false);
                    Consumer consumer = EntityType.createDefaultStackConfig((ServerLevel)serverLevel, (ItemStack)itemstack, (Player)context.getPlayer());
                    HatStandEntity dummy = (HatStandEntity)type.create(serverLevel, consumer, blockpos, MobSpawnType.SPAWN_EGG, false, false);
                    if (dummy == null) {
                        return InteractionResult.FAIL;
                    }
                    float rotation = (float)Mth.floor((double)(((double)Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 11.25) / 22.5)) * 22.5f;
                    dummy.moveTo(vec3.x, vec3.y, vec3.z, rotation, 0.0f);
                    dummy.setYHeadRot(rotation);
                    level.addFreshEntity((Entity)dummy);
                    level.playSound(null, dummy.getX(), dummy.getY(), dummy.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                    dummy.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)context.getPlayer());
                }
                itemstack.shrink(1);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }
}

