/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

record FullBucketCauldronInteraction(BlockState fullCauldron, ItemStack filleBucket) implements FaucetTarget.BlState,
FaucetSource.BlState
{
    @Override
    public FluidOffer getProvidedFluid(Level level, BlockPos pos, Direction dir, BlockState source) {
        Pair pair;
        if (source.is(this.fullCauldron.getBlock()) && (pair = SoftFluidStack.fromItem((ItemStack)this.filleBucket.copy())) != null) {
            SoftFluidStack stack = (SoftFluidStack)pair.getFirst();
            int amount = source.hasProperty((Property)LayeredCauldronBlock.LEVEL) ? ((Integer)source.getValue((Property)LayeredCauldronBlock.LEVEL)).intValue() : stack.getCount();
            return FluidOffer.of((Holder<SoftFluid>)stack.getHolder(), amount, amount);
        }
        return null;
    }

    @Override
    public void drain(Level level, BlockPos pos, Direction dir, BlockState source, int amount) {
        level.setBlock(pos, Blocks.CAULDRON.defaultBlockState(), 3);
    }

    @Override
    public Integer fill(Level level, BlockPos pos, BlockState state, FluidOffer offer) {
        Pair pair;
        if ((state.is(Blocks.CAULDRON) || state.is(this.fullCauldron.getBlock()) && state.hasProperty((Property)LayeredCauldronBlock.LEVEL)) && (pair = SoftFluidStack.fromItem((ItemStack)this.filleBucket.copy())) != null) {
            SoftFluidStack fluidStack = (SoftFluidStack)pair.getFirst();
            int minAmount = offer.minAmount();
            SoftFluidStack wantToInsert = offer.fluid();
            if (wantToInsert.is(fluidStack.getHolder())) {
                int added;
                BlockState toPlace = this.fullCauldron;
                if (state.hasProperty((Property)LayeredCauldronBlock.LEVEL)) {
                    int current = (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
                    if (current == 3) {
                        return null;
                    }
                    int newAmount = current + minAmount;
                    if (newAmount > 3) {
                        return null;
                    }
                    added = minAmount;
                    toPlace = (BlockState)toPlace.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(newAmount));
                } else {
                    if (wantToInsert.getCount() < fluidStack.getCount() && minAmount < fluidStack.getCount()) {
                        return null;
                    }
                    added = fluidStack.getCount();
                }
                level.setBlock(pos, toPlace, 3);
                return added;
            }
        }
        return null;
    }
}

