/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherArmBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherHeadBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpringLauncherArmBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpringLauncherBlock
extends Block {
    protected static final VoxelShape PISTON_BASE_EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_WEST_AABB = Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape PISTON_BASE_NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_UP_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_DOWN_AABB = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty EXTENDED = BlockStateProperties.EXTENDED;

    public SpringLauncherBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return (Boolean)state.getValue((Property)EXTENDED) != false ? PushReaction.BLOCK : PushReaction.NORMAL;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)EXTENDED);
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return (Boolean)state.getValue((Property)EXTENDED);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, EXTENDED});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)EXTENDED)).booleanValue()) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.DOWN -> PISTON_BASE_DOWN_AABB;
                default -> PISTON_BASE_UP_AABB;
                case Direction.NORTH -> PISTON_BASE_NORTH_AABB;
                case Direction.SOUTH -> PISTON_BASE_SOUTH_AABB;
                case Direction.WEST -> PISTON_BASE_WEST_AABB;
                case Direction.EAST -> PISTON_BASE_EAST_AABB;
            };
        }
        return Shapes.block();
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.checkForMove(state, level, pos);
    }

    private void checkForMove(BlockState state, Level level, BlockPos pos) {
        if (!level.isClientSide()) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            boolean isPowered = this.shouldBeExtended(level, pos, direction);
            BlockPos offset = pos.offset(direction.getNormal());
            if (isPowered && !((Boolean)state.getValue((Property)EXTENDED)).booleanValue()) {
                BlockState sand;
                Block block;
                if (direction == Direction.UP && (block = (sand = level.getBlockState(offset)).getBlock()) instanceof FallingBlock) {
                    FallingBlock fb = (FallingBlock)block;
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 4);
                    fb.tick(sand, (ServerLevel)level, offset, level.random);
                    level.setBlock(pos, state, 4);
                }
                boolean hasBrokenBlock = false;
                BlockState targetBlock = level.getBlockState(offset);
                if (targetBlock.getPistonPushReaction() == PushReaction.DESTROY || targetBlock.isAir()) {
                    BlockEntity blockEntity = targetBlock.hasBlockEntity() ? level.getBlockEntity(offset) : null;
                    SpringLauncherBlock.dropResources((BlockState)targetBlock, (LevelAccessor)level, (BlockPos)offset, (BlockEntity)blockEntity);
                    hasBrokenBlock = true;
                }
                if (hasBrokenBlock) {
                    level.setBlockAndUpdate(offset, (BlockState)((BlockState)ModRegistry.SPRING_LAUNCHER_ARM.get().defaultBlockState().setValue((Property)SpringLauncherArmBlock.EXTENDING, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)direction));
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(true)));
                    level.playSound(null, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.53f, level.random.nextFloat() * 0.25f + 0.45f);
                    level.gameEvent(null, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
                }
            } else if (!isPowered && ((Boolean)state.getValue((Property)EXTENDED)).booleanValue()) {
                BlockState bs = level.getBlockState(offset);
                if (bs.getBlock() instanceof SpringLauncherHeadBlock && direction == bs.getValue((Property)FACING)) {
                    level.setBlockAndUpdate(offset, (BlockState)((BlockState)ModRegistry.SPRING_LAUNCHER_ARM.get().defaultBlockState().setValue((Property)SpringLauncherArmBlock.EXTENDING, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)direction));
                    level.playSound(null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.53f, level.random.nextFloat() * 0.15f + 0.45f);
                    level.gameEvent(null, (Holder)GameEvent.BLOCK_DEACTIVATE, pos);
                } else if (bs.getBlock() instanceof SpringLauncherArmBlock && direction == bs.getValue((Property)FACING) && level.getBlockEntity(offset) instanceof SpringLauncherArmBlockTile) {
                    level.scheduleTick(pos, level.getBlockState(pos).getBlock(), 1);
                }
            }
        }
    }

    private boolean shouldBeExtended(Level level, BlockPos pos, Direction facing) {
        for (Direction direction : Direction.values()) {
            if (direction == facing || !level.hasSignal(pos.relative(direction), direction)) continue;
            return true;
        }
        if (level.hasSignal(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.above();
        for (Direction direction1 : Direction.values()) {
            if (direction1 == Direction.DOWN || !level.hasSignal(blockpos.relative(direction1), direction1)) continue;
            return true;
        }
        return false;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(state, level, pos, neighborBlock, fromPos, moving);
        this.checkForMove(state, level, pos);
    }
}

