/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionRenderInfo;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedBlockAndTintGetter;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.material.CardinalLightingMode;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.task.Plan;
import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.LightUpdatedVisual;
import dev.engine_room.flywheel.api.visual.SectionTrackedVisual;
import dev.engine_room.flywheel.api.visual.ShaderLightVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visual.Visual;
import dev.engine_room.flywheel.api.visualization.BlockEntityVisualizer;
import dev.engine_room.flywheel.api.visualization.VisualEmbedding;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizerRegistry;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.ModelUtil;
import dev.engine_room.flywheel.lib.model.baked.BlockModelBuilder;
import dev.engine_room.flywheel.lib.task.ForEachPlan;
import dev.engine_room.flywheel.lib.task.NestedPlan;
import dev.engine_room.flywheel.lib.task.PlanMap;
import dev.engine_room.flywheel.lib.task.RunnablePlan;
import dev.engine_room.flywheel.lib.visual.AbstractEntityVisual;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.MutablePair;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class ContraptionVisual<E extends AbstractContraptionEntity>
extends AbstractEntityVisual<E>
implements DynamicVisual,
TickableVisual,
LightUpdatedVisual,
ShaderLightVisual {
    protected static final int LIGHT_PADDING = 1;
    protected final VisualEmbedding embedding;
    protected final List<BlockEntityVisual<?>> children = new ArrayList();
    protected final List<ActorVisual> actors = new ArrayList<ActorVisual>();
    protected final PlanMap<DynamicVisual, DynamicVisual.Context> dynamicVisuals = new PlanMap();
    protected final PlanMap<TickableVisual, TickableVisual.Context> tickableVisuals = new PlanMap();
    protected VirtualRenderWorld virtualRenderWorld;
    protected Model model;
    protected TransformedInstance structure;
    protected SectionTrackedVisual.SectionCollector sectionCollector;
    protected long minSection;
    protected long maxSection;
    protected long minBlock;
    protected long maxBlock;
    private final PoseStack contraptionMatrix = new PoseStack();

    public ContraptionVisual(VisualizationContext ctx, E entity, float partialTick) {
        super(ctx, entity, partialTick);
        this.embedding = ctx.createEmbedding(Vec3i.ZERO);
        this.setEmbeddingMatrices(partialTick);
        Contraption contraption = ((AbstractContraptionEntity)((Object)entity)).getContraption();
        if (contraption == null) {
            return;
        }
        this.setupModel(contraption);
        this.setupChildren(partialTick, contraption);
        this.setupActors(partialTick, contraption);
    }

    private void setupModel(Contraption contraption) {
        this.virtualRenderWorld = ContraptionRenderInfo.setupRenderWorld(this.level, contraption);
        final Contraption.RenderedBlocks blocks = contraption.getRenderedBlocks();
        WrappedBlockAndTintGetter modelWorld = new WrappedBlockAndTintGetter(this, (BlockAndTintGetter)this.virtualRenderWorld){

            @Override
            public BlockState getBlockState(BlockPos pos) {
                return blocks.lookup().apply(pos);
            }
        };
        this.model = new BlockModelBuilder((BlockAndTintGetter)modelWorld, blocks.positions()).materialFunc((renderType, aBoolean) -> SimpleMaterial.builderOf((Material)ModelUtil.getMaterial((RenderType)renderType, (boolean)aBoolean)).cardinalLightingMode(CardinalLightingMode.CHUNK)).build();
        Instancer instancer = this.embedding.instancerProvider().instancer(InstanceTypes.TRANSFORMED, this.model);
        if (this.structure == null) {
            this.structure = (TransformedInstance)instancer.createInstance();
        } else {
            instancer.stealInstance((Instance)this.structure);
        }
        this.structure.setChanged();
    }

    private void setupChildren(float partialTick, Contraption contraption) {
        this.children.forEach(Visual::delete);
        this.children.clear();
        for (BlockEntity be : contraption.getRenderedBEs()) {
            this.setupVisualizer(be, partialTick);
        }
    }

    private void setupActors(float partialTick, Contraption contraption) {
        this.actors.forEach(ActorVisual::delete);
        this.actors.clear();
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> actor : contraption.getActors()) {
            this.setupActor(actor, partialTick);
        }
    }

    protected <T extends BlockEntity> void setupVisualizer(T be, float partialTicks) {
        BlockEntityVisualizer visualizer = VisualizerRegistry.getVisualizer((BlockEntityType)be.getType());
        if (visualizer == null) {
            return;
        }
        Level level = be.getLevel();
        be.setLevel((Level)this.virtualRenderWorld);
        BlockEntityVisual visual = visualizer.createVisual((VisualizationContext)this.embedding, be, partialTicks);
        this.children.add(visual);
        if (visual instanceof DynamicVisual) {
            DynamicVisual dynamic = (DynamicVisual)visual;
            this.dynamicVisuals.add((Object)dynamic, dynamic.planFrame());
        }
        if (visual instanceof TickableVisual) {
            TickableVisual tickable = (TickableVisual)visual;
            this.tickableVisuals.add((Object)tickable, tickable.planTick());
        }
        be.setLevel(level);
    }

    private void setupActor(MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> actor, float partialTick) {
        StructureTemplate.StructureBlockInfo blockInfo;
        MovementBehaviour movementBehaviour;
        MovementContext context = (MovementContext)actor.getRight();
        if (context == null) {
            return;
        }
        if (context.world == null) {
            context.world = this.level;
        }
        if ((movementBehaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)(blockInfo = (StructureTemplate.StructureBlockInfo)actor.getLeft()).state())) == null) {
            return;
        }
        ActorVisual visual = movementBehaviour.createVisual((VisualizationContext)this.embedding, this.virtualRenderWorld, context);
        if (visual == null) {
            return;
        }
        this.actors.add(visual);
    }

    public Plan<TickableVisual.Context> planTick() {
        return NestedPlan.of((Plan[])new Plan[]{ForEachPlan.of(() -> this.actors, ActorVisual::tick), this.tickableVisuals});
    }

    public Plan<DynamicVisual.Context> planFrame() {
        return NestedPlan.of((Plan[])new Plan[]{RunnablePlan.of(this::beginFrame), ForEachPlan.of(() -> this.actors, ActorVisual::beginFrame), this.dynamicVisuals});
    }

    protected void beginFrame(DynamicVisual.Context context) {
        float partialTick = context.partialTick();
        this.setEmbeddingMatrices(partialTick);
        if (this.hasMovedSections()) {
            this.sectionCollector.sections(this.collectLightSections());
        }
        if (this.hasMovedBlocks()) {
            this.updateLight(partialTick);
        }
        Contraption contraption = ((AbstractContraptionEntity)this.entity).getContraption();
        if (contraption.deferInvalidate) {
            this.setupModel(contraption);
            this.setupChildren(partialTick, contraption);
            this.setupActors(partialTick, contraption);
            contraption.deferInvalidate = false;
        }
    }

    private void setEmbeddingMatrices(float partialTick) {
        double z;
        double y;
        double x;
        Vec3i origin = this.renderOrigin();
        if (((AbstractContraptionEntity)this.entity).isPrevPosInvalid()) {
            x = ((AbstractContraptionEntity)this.entity).getX() - (double)origin.getX();
            y = ((AbstractContraptionEntity)this.entity).getY() - (double)origin.getY();
            z = ((AbstractContraptionEntity)this.entity).getZ() - (double)origin.getZ();
        } else {
            x = Mth.lerp((double)partialTick, (double)((AbstractContraptionEntity)this.entity).xo, (double)((AbstractContraptionEntity)this.entity).getX()) - (double)origin.getX();
            y = Mth.lerp((double)partialTick, (double)((AbstractContraptionEntity)this.entity).yo, (double)((AbstractContraptionEntity)this.entity).getY()) - (double)origin.getY();
            z = Mth.lerp((double)partialTick, (double)((AbstractContraptionEntity)this.entity).zo, (double)((AbstractContraptionEntity)this.entity).getZ()) - (double)origin.getZ();
        }
        this.contraptionMatrix.setIdentity();
        this.contraptionMatrix.translate(x, y, z);
        ((AbstractContraptionEntity)this.entity).applyLocalTransforms(this.contraptionMatrix, partialTick);
        this.embedding.transforms((Matrix4fc)this.contraptionMatrix.last().pose(), (Matrix3fc)this.contraptionMatrix.last().normal());
    }

    public void updateLight(float partialTick) {
    }

    public LongSet collectLightSections() {
        AABB boundingBox = ((AbstractContraptionEntity)this.entity).getBoundingBox();
        int minSectionX = ContraptionVisual.minLightSection(boundingBox.minX);
        int minSectionY = ContraptionVisual.minLightSection(boundingBox.minY);
        int minSectionZ = ContraptionVisual.minLightSection(boundingBox.minZ);
        int maxSectionX = ContraptionVisual.maxLightSection(boundingBox.maxX);
        int maxSectionY = ContraptionVisual.maxLightSection(boundingBox.maxY);
        int maxSectionZ = ContraptionVisual.maxLightSection(boundingBox.maxZ);
        this.minSection = SectionPos.asLong((int)minSectionX, (int)minSectionY, (int)minSectionZ);
        this.maxSection = SectionPos.asLong((int)maxSectionX, (int)maxSectionY, (int)maxSectionZ);
        LongArraySet longSet = new LongArraySet();
        for (int x = 0; x <= maxSectionX - minSectionX; ++x) {
            for (int y = 0; y <= maxSectionY - minSectionY; ++y) {
                for (int z = 0; z <= maxSectionZ - minSectionZ; ++z) {
                    longSet.add(SectionPos.offset((long)this.minSection, (int)x, (int)y, (int)z));
                }
            }
        }
        return longSet;
    }

    protected boolean hasMovedBlocks() {
        AABB boundingBox = ((AbstractContraptionEntity)this.entity).getBoundingBox();
        int minX = ContraptionVisual.minLight(boundingBox.minX);
        int minY = ContraptionVisual.minLight(boundingBox.minY);
        int minZ = ContraptionVisual.minLight(boundingBox.minZ);
        int maxX = ContraptionVisual.maxLight(boundingBox.maxX);
        int maxY = ContraptionVisual.maxLight(boundingBox.maxY);
        int maxZ = ContraptionVisual.maxLight(boundingBox.maxZ);
        return this.minBlock != BlockPos.asLong((int)minX, (int)minY, (int)minZ) || this.maxBlock != BlockPos.asLong((int)maxX, (int)maxY, (int)maxZ);
    }

    protected boolean hasMovedSections() {
        AABB boundingBox = ((AbstractContraptionEntity)this.entity).getBoundingBox();
        int minSectionX = ContraptionVisual.minLightSection(boundingBox.minX);
        int minSectionY = ContraptionVisual.minLightSection(boundingBox.minY);
        int minSectionZ = ContraptionVisual.minLightSection(boundingBox.minZ);
        int maxSectionX = ContraptionVisual.maxLightSection(boundingBox.maxX);
        int maxSectionY = ContraptionVisual.maxLightSection(boundingBox.maxY);
        int maxSectionZ = ContraptionVisual.maxLightSection(boundingBox.maxZ);
        return this.minSection != SectionPos.asLong((int)minSectionX, (int)minSectionY, (int)minSectionZ) || this.maxSection != SectionPos.asLong((int)maxSectionX, (int)maxSectionY, (int)maxSectionZ);
    }

    public void setSectionCollector(SectionTrackedVisual.SectionCollector collector) {
        this.sectionCollector = collector;
    }

    protected void _delete() {
        this.children.forEach(Visual::delete);
        this.actors.forEach(ActorVisual::delete);
        if (this.structure != null) {
            this.structure.delete();
        }
    }

    public static int minLight(double aabbPos) {
        return Mth.floor((double)aabbPos) - 1;
    }

    public static int maxLight(double aabbPos) {
        return Mth.ceil((double)aabbPos) + 1;
    }

    public static int minLightSection(double aabbPos) {
        return SectionPos.blockToSectionCoord((int)ContraptionVisual.minLight(aabbPos));
    }

    public static int maxLightSection(double aabbPos) {
        return SectionPos.blockToSectionCoord((int)ContraptionVisual.maxLight(aabbPos));
    }
}

