/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.computercraft.implementation.peripherals;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.AttachedComputerPacket;
import com.simibubi.create.compat.computercraft.implementation.ComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.concurrent.atomic.AtomicInteger;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyncedPeripheral<T extends SmartBlockEntity>
implements IPeripheral {
    protected final T blockEntity;
    private final AtomicInteger computers = new AtomicInteger();

    public SyncedPeripheral(T blockEntity) {
        this.blockEntity = blockEntity;
    }

    public void attach(@NotNull IComputerAccess computer) {
        this.computers.incrementAndGet();
        this.updateBlockEntity();
    }

    public void detach(@NotNull IComputerAccess computer) {
        this.computers.decrementAndGet();
        this.updateBlockEntity();
    }

    private void updateBlockEntity() {
        boolean hasAttachedComputer = this.computers.get() > 0;
        ((AbstractComputerBehaviour)((SmartBlockEntity)this.blockEntity).getBehaviour(ComputerBehaviour.TYPE)).setHasAttachedComputer(hasAttachedComputer);
        CatnipServices.NETWORK.sendToAllClients((CustomPacketPayload)new AttachedComputerPacket(this.blockEntity.getBlockPos(), hasAttachedComputer));
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }
}

