/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass.mixin;

import dev.ultimatchamp.bettergrass.BetterGrassify;
import dev.ultimatchamp.bettergrass.config.BetterGrassifyConfig;
import dev.ultimatchamp.bettergrass.model.BetterGrassifyUnbakedModel;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBakery.class})
public class ModelLoaderMixin {
    @Shadow
    @Final
    private Map<ModelResourceLocation, UnbakedModel> topLevelModels;

    @Inject(method={"registerModel(Lnet/minecraft/client/resources/model/ModelResourceLocation;Lnet/minecraft/client/resources/model/UnbakedModel;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void bettergrass$onAddModelToBake(ModelResourceLocation id, UnbakedModel unbakedModel, CallbackInfo ci) {
        ModelResourceLocation modelId;
        if (id instanceof ModelResourceLocation && !(modelId = id).getVariant().equals("inventory")) {
            List<String> blocks = BetterGrassify.getBlocks();
            for (String block : blocks) {
                BetterGrassifyUnbakedModel newModel;
                if (!modelId.id().toString().equals(block)) continue;
                if (modelId.getVariant().contains("snowy=true")) {
                    if (!BetterGrassifyConfig.load().snowy) continue;
                    newModel = new BetterGrassifyUnbakedModel(unbakedModel);
                    this.topLevelModels.put(id, newModel);
                    ci.cancel();
                    continue;
                }
                newModel = new BetterGrassifyUnbakedModel(unbakedModel);
                this.topLevelModels.put(id, newModel);
                ci.cancel();
            }
            if (modelId.id().toString().equals("minecraft:dirt") && (blocks.contains("minecraft:dirt_path") || blocks.contains("minecraft:farmland"))) {
                BetterGrassifyUnbakedModel newModel = new BetterGrassifyUnbakedModel(unbakedModel);
                this.topLevelModels.put(id, newModel);
                ci.cancel();
            }
        }
    }
}

