/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.network.packet.SpawnLaserPacket;
import de.ellpeck.actuallyadditions.mod.network.packet.SyncPlayerPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public final class PacketHelperServer {
    public static void syncPlayerData(Player player, boolean log) {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Log", log);
        CompoundTag data = new CompoundTag();
        PlayerData.getDataFromPlayer(player).writeToNBT(data, false);
        compound.put("Data", (Tag)data);
        ActuallyAdditions.LOGGER.debug("Sending data {}", (Object)data);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((CustomPacketPayload)new SyncPlayerPacket(data));
        }
    }

    public static void spawnLaserWithTimeServer(ServerLevel world, double startX, double startY, double startZ, double endX, double endY, double endZ, int color, int maxAge, double rotationTime, float size, float alpha) {
        if (!world.isClientSide) {
            PacketDistributor.sendToPlayersNear((ServerLevel)world, null, (double)startX, (double)startY, (double)startZ, (double)96.0, (CustomPacketPayload)new SpawnLaserPacket(startX, startY, startZ, endX, endY, endZ, color, maxAge, rotationTime, size, alpha), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

