/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.MiningLensRecipe;
import de.ellpeck.actuallyadditions.mod.util.NoAdvRecipeOutput;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class MiningLensGenerator
extends RecipeProvider {
    public MiningLensGenerator(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    public String getName() {
        return "Mining Lens " + super.getName();
    }

    protected void buildRecipes(@Nonnull RecipeOutput recipeOutput) {
        this.buildMiningLens(new NoAdvRecipeOutput(recipeOutput));
    }

    private ResourceLocation folderRecipe(String folder, String recipe) {
        return ActuallyAdditions.modLoc(folder + "/" + recipe);
    }

    private void buildStoneOre(RecipeOutput consumer, int weight, ItemLike output) {
        this.buildTagOre(consumer, ActuallyTags.Items.STONE_ORE_REPLACEABLES, "stone", weight, output);
    }

    private void buildNetherOre(RecipeOutput consumer, int weight, ItemLike output) {
        this.buildTagOre(consumer, (TagKey<Item>)Tags.Items.ORE_BEARING_GROUND_NETHERRACK, "nether", weight, output);
    }

    private void buildDeepSlateOre(RecipeOutput consumer, int weight, ItemLike output) {
        this.buildTagOre(consumer, ActuallyTags.Items.DEEPSLATE_ORE_REPLACEABLES, "deepslate", weight, output);
    }

    private void buildTagOre(RecipeOutput consumer, TagKey<Item> tag, String prefix, int weight, ItemLike output) {
        consumer.accept(this.folderRecipe("mininglens", prefix + "_" + MiningLensGenerator.getItemName((ItemLike)output)), (Recipe)new MiningLensRecipe(Ingredient.of(tag), weight, output.asItem().getDefaultInstance()), null);
    }

    private void buildMiningLens(RecipeOutput consumer) {
        this.buildStoneOre(consumer, 5000, (ItemLike)Items.COAL_ORE);
        this.buildStoneOre(consumer, 5000, (ItemLike)Items.COPPER_ORE);
        this.buildStoneOre(consumer, 3000, (ItemLike)Items.IRON_ORE);
        this.buildStoneOre(consumer, 500, (ItemLike)Items.GOLD_ORE);
        this.buildNetherOre(consumer, 500, (ItemLike)Items.NETHER_GOLD_ORE);
        this.buildStoneOre(consumer, 50, (ItemLike)Items.DIAMOND_ORE);
        this.buildStoneOre(consumer, 250, (ItemLike)Items.LAPIS_ORE);
        this.buildStoneOre(consumer, 200, (ItemLike)Items.REDSTONE_ORE);
        this.buildStoneOre(consumer, 30, (ItemLike)Items.EMERALD_ORE);
        this.buildNetherOre(consumer, 3000, (ItemLike)Items.NETHER_QUARTZ_ORE);
        this.buildStoneOre(consumer, 3000, (ItemLike)ActuallyBlocks.BLACK_QUARTZ_ORE.getItem());
        this.buildNetherOre(consumer, 1, (ItemLike)Items.ANCIENT_DEBRIS);
        this.buildDeepSlateOre(consumer, 2000, (ItemLike)Items.DEEPSLATE_COAL_ORE);
        this.buildDeepSlateOre(consumer, 3000, (ItemLike)Items.DEEPSLATE_IRON_ORE);
        this.buildDeepSlateOre(consumer, 3000, (ItemLike)Items.DEEPSLATE_COPPER_ORE);
        this.buildDeepSlateOre(consumer, 500, (ItemLike)Items.DEEPSLATE_GOLD_ORE);
        this.buildDeepSlateOre(consumer, 50, (ItemLike)Items.DEEPSLATE_DIAMOND_ORE);
        this.buildDeepSlateOre(consumer, 250, (ItemLike)Items.DEEPSLATE_LAPIS_ORE);
        this.buildDeepSlateOre(consumer, 200, (ItemLike)Items.DEEPSLATE_REDSTONE_ORE);
        this.buildDeepSlateOre(consumer, 30, (ItemLike)Items.DEEPSLATE_EMERALD_ORE);
    }
}

