/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.transporter.filter;

import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidFilter
extends RegulatorFilter<FluidStack, IFluidHandler> {
    public FluidFilter(int locX, int locY, int sizeX, int sizeY, int smallMultiplier, int bigMultiplier, int maxAmount, String label) {
        super(locX, locY, sizeX, sizeY, smallMultiplier, bigMultiplier, maxAmount, label);
    }

    @Override
    public boolean matches(FluidStack stack, IFluidHandler handler) {
        if (this.isEmpty()) {
            return !this.isWhitelisted();
        }
        for (IFilter.GhostSlot slot : this.getFilterSlots()) {
            FluidStack original = FluidUtil.getFluidContained((ItemStack)slot.getStack()).orElse(null);
            if (original == null || !FluidStack.isSameFluidSameComponents((FluidStack)original, (FluidStack)stack)) continue;
            return this.isWhitelisted();
        }
        return !this.isWhitelisted();
    }

    @Override
    public int getExtractAmount(FluidStack stack, IFluidHandler handler) {
        if (!this.matches(stack, handler)) {
            return 0;
        }
        if (this.isEmpty() || !this.isRegulated() || !this.isWhitelisted()) {
            return stack.getAmount();
        }
        return Math.max(0, this.getStorageAmount(stack, handler) - this.getFilterAmount(stack));
    }

    @Override
    public int getInsertAmount(FluidStack stack, IFluidHandler handler) {
        if (!this.matches(stack, handler)) {
            return 0;
        }
        if (this.isEmpty() || !this.isRegulated() || !this.isWhitelisted()) {
            return stack.getAmount();
        }
        return Math.max(0, this.getFilterAmount(stack) - this.getStorageAmount(stack, handler));
    }

    @Override
    public int getFilterAmount(FluidStack stack) {
        int amount = 0;
        for (IFilter.GhostSlot slot : this.getFilterSlots()) {
            FluidStack original = FluidUtil.getFluidContained((ItemStack)slot.getStack()).orElse(null);
            if (original == null || !FluidStack.isSameFluidSameComponents((FluidStack)original, (FluidStack)stack)) continue;
            if (!this.isRegulated()) {
                return 1;
            }
            amount += slot.getAmount();
        }
        return amount;
    }

    @Override
    public int getStorageAmount(FluidStack stack, @NotNull IFluidHandler handler) {
        int amount = 0;
        for (int i = 0; i < handler.getTanks(); ++i) {
            if (!handler.isFluidValid(i, stack) || !FluidStack.isSameFluidSameComponents((FluidStack)handler.getFluidInTank(i), (FluidStack)stack)) continue;
            amount += handler.getFluidInTank(i).getAmount();
        }
        return amount;
    }
}

