/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.common.capability.FamiliarSettingsData;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.registry.OccultismDataStorage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;

public class MessageToggleFamiliarSettings
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"toggle_familiar_settings");
    public static final CustomPacketPayload.Type<MessageToggleFamiliarSettings> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageToggleFamiliarSettings> STREAM_CODEC = CustomPacketPayload.codec(MessageToggleFamiliarSettings::encode, MessageToggleFamiliarSettings::new);
    public Map<EntityType<?>, Boolean> familiarsPressed;

    public MessageToggleFamiliarSettings(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageToggleFamiliarSettings(Map<EntityType<?>, Boolean> familiarsPressed) {
        this.familiarsPressed = familiarsPressed;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        FamiliarSettingsData cap = (FamiliarSettingsData)player.getData(OccultismDataStorage.FAMILIAR_SETTINGS.get());
        for (Map.Entry<EntityType<?>, Boolean> toggle : this.familiarsPressed.entrySet()) {
            if (!toggle.getValue().booleanValue()) continue;
            cap.setFamiliarEnabled(toggle.getKey(), !cap.isFamiliarEnabled(toggle.getKey()));
            player.displayClientMessage((Component)Component.translatable((String)("message.occultism.familiar." + BuiltInRegistries.ENTITY_TYPE.getKey(toggle.getKey()).getPath() + (cap.isFamiliarEnabled(toggle.getKey()) ? ".enabled" : ".disabled"))), true);
        }
        FamiliarSettingsData.syncFor(player);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsData.getFamiliars()) {
            buf.writeBoolean(this.familiarsPressed.get(familiar).booleanValue());
        }
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.familiarsPressed = new HashMap();
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsData.getFamiliars()) {
            this.familiarsPressed.put(familiar, buf.readBoolean());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

