/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.loot;

import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismItems;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class OccultismEntityLoot
extends EntityLootSubProvider {
    public OccultismEntityLoot(HolderLookup.Provider pRegistries) {
        super(FeatureFlags.REGISTRY.allFlags(), pRegistries);
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> pGenerator) {
        this.generate();
        this.map.forEach((key, entityType) -> entityType.forEach(pGenerator::accept));
    }

    public void generate() {
        this.add((EntityType)OccultismEntities.POSSESSED_SHULKER_TYPE.get(), this.shulkerLootTable());
        this.add((EntityType)OccultismEntities.POSSESSED_WARDEN_TYPE.get(), this.wardenLootTable());
        this.add((EntityType)OccultismEntities.POSSESSED_HOGLIN_TYPE.get(), this.hoglinLootTable());
        this.add((EntityType)OccultismEntities.POSSESSED_WITCH_TYPE.get(), this.witchLootTable());
        this.add((EntityType)OccultismEntities.POSSESSED_BLAZE_TYPE.get(), this.blazeLootTable());
        this.add((EntityType)OccultismEntities.POSSESSED_WEAK_SHULKER_TYPE.get(), this.weakShulkerTable());
        this.add((EntityType)OccultismEntities.POSSESSED_GHAST_TYPE.get(), this.ghastLootTable());
        this.add((EntityType)OccultismEntities.POSSESSED_ELDER_GUARDIAN_TYPE.get(), this.elderGuardianLootTable());
        this.add((EntityType)OccultismEntities.WILD_HORDE_HUSK_TYPE.get(), this.huskLootTable());
        this.add((EntityType)OccultismEntities.WILD_HORDE_DROWNED_TYPE.get(), this.drownedLootTable());
        this.add((EntityType)OccultismEntities.WILD_HORDE_CREEPER_TYPE.get(), this.creeperLootTable());
        this.add((EntityType)OccultismEntities.WILD_HORDE_SILVERFISH_TYPE.get(), this.silverfishLootTable());
        this.add((EntityType)OccultismEntities.POSSESSED_WEAK_BREEZE_TYPE.get(), this.weakBreezeTable());
        this.add((EntityType)OccultismEntities.POSSESSED_BREEZE_TYPE.get(), this.breezeTable());
        this.add((EntityType)OccultismEntities.POSSESSED_STRONG_BREEZE_TYPE.get(), this.strongBreezeTable());
        this.add((EntityType)OccultismEntities.POSSESSED_EVOKER_TYPE.get(), this.evokerTable());
        this.add((EntityType)OccultismEntities.POSSESSED_ENDERMITE_TYPE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.END_STONE).setWeight(99).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.END_STONE_BRICKS).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FERMENTED_SPIDER_EYE).setWeight(2).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPIDER_EYE).setWeight(2).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_EYE).setWeight(1).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).when(LootItemRandomChanceCondition.randomChance((NumberProvider)ConstantValue.exactly((float)0.25f)))));
        this.add((EntityType)OccultismEntities.POSSESSED_ENDERMAN_TYPE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_PEARL).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE)).when(LootItemRandomChanceCondition.randomChance((float)0.1f))));
        this.add((EntityType)OccultismEntities.POSSESSED_SKELETON_TYPE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ARROW).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SKELETON_SKULL).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        this.add((EntityType)OccultismEntities.POSSESSED_PHANTOM_TYPE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PHANTOM_MEMBRANE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.5f, (float)2.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WIND_CHARGE).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).when(LootItemRandomChanceCondition.randomChance((NumberProvider)ConstantValue.exactly((float)0.05f)))));
        this.add((EntityType)OccultismEntities.AFRIT_WILD_TYPE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)OccultismItems.AFRIT_ESSENCE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.7f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        this.add((EntityType)OccultismEntities.MARID_UNBOUND_TYPE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)OccultismItems.MARID_ESSENCE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.9f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        this.add((EntityType)OccultismEntities.WILD_HUNT_WITHER_SKELETON_TYPE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COAL).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)-1.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.WITHER_SKELETON_SKULL)).when(LootItemKilledByPlayerCondition.killedByPlayer()).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.67f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)Items.WITHER_ROSE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(LootItemRandomChanceCondition.randomChance((float)0.3f)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE)).when(LootItemKilledByPlayerCondition.killedByPlayer()).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.1f, (float)1.0f)))));
        this.add((EntityType)OccultismEntities.WILD_HUNT_SKELETON_TYPE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ARROW).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        this.add((EntityType)OccultismEntities.GOAT_OF_MERCY_TYPE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(OccultismItems.CRUELTY_ESSENCE).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        this.add((EntityType)OccultismEntities.POSSESSED_ZOMBIE_PIGLIN_TYPE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(OccultismItems.DEMONIC_MEAT).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(OccultismItems.TALLOW).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).when(LootItemRandomChanceCondition.randomChance((NumberProvider)ConstantValue.exactly((float)0.8f)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PORKCHOP).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ROTTEN_FLESH).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).when(LootItemRandomChanceCondition.randomChance((NumberProvider)ConstantValue.exactly((float)0.33f)))));
        this.add((EntityType)OccultismEntities.POSSESSED_BEE_TYPE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(OccultismItems.CURSED_HONEY).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.5f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.3f, (float)1.0f))))));
    }

    public LootTable.Builder elderGuardianLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PRISMARINE_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COD).setWeight(3).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PRISMARINE_CRYSTALS).setWeight(2).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem())).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.WET_SPONGE)).when(LootItemKilledByPlayerCondition.killedByPlayer())).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.FISHING_FISH).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot()))).when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.025f, (float)0.01f))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(8)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COAST_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NAUTILUS_SHELL).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)Items.HEART_OF_THE_SEA).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.4f, (float)0.1f))));
    }

    public LootTable.Builder ghastLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GHAST_TEAR).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GUNPOWDER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))));
    }

    public LootTable.Builder hoglinLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHERITE_SCRAP).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_BRICK).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PIGLIN_BANNER_PATTERN).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_PIGSTEP).setWeight(1)));
    }

    public LootTable.Builder shulkerLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHULKER_SHELL)).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.25f, (float)0.1f))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHULKER_SHELL))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CHORUS_FLOWER)).when(LootItemRandomChanceCondition.randomChance((float)0.1f)));
    }

    public LootTable.Builder wardenLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ECHO_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)6.0f, (float)9.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(8)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DISC_FRAGMENT_5).setWeight(9)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_OTHERSIDE))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SCULK).setWeight(9)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SCULK_VEIN).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SCULK_CATALYST).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SCULK_SHRIEKER).setWeight(6)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SCULK_SENSOR).setWeight(12)));
    }

    public LootTable.Builder weakShulkerTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHULKER_SHELL).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)))).when(LootItemRandomChanceCondition.randomChance((float)0.1f))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CHORUS_FRUIT).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))));
    }

    public LootTable.Builder huskLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ARCHER_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MINER_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PRIZE_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SKULL_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ARMS_UP_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BREWER_POTTERY_SHERD).setWeight(1)));
    }

    public LootTable.Builder drownedLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SNIFFER_EGG).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TURTLE_EGG).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TRIDENT).setWeight(3))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ANGLER_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHELTER_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SNORT_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BLADE_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EXPLORER_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MOURNER_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PLENTY_POTTERY_SHERD).setWeight(1)));
    }

    public LootTable.Builder creeperLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_13).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_CAT).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_BLOCKS).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_CHIRP).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_FAR).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_MALL).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_MELLOHI).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_STAL).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_STRAD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_WARD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_11).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_WAIT).setWeight(1)));
    }

    public LootTable.Builder silverfishLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_RELIC).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.HOST_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BURN_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DANGER_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FRIEND_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.HEART_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.HEARTBREAK_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.HOWL_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHEAF_POTTERY_SHERD).setWeight(1)));
    }

    public LootTable.Builder weakBreezeTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TRIAL_KEY).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OMINOUS_BOTTLE).setWeight(1)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.5f, (float)2.0f)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GUSTER_POTTERY_SHERD).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SCRAPE_POTTERY_SHERD).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(7)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_CREATOR_MUSIC_BOX).setWeight(1)));
    }

    public LootTable.Builder breezeTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OMINOUS_TRIAL_KEY).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BREEZE_ROD).setWeight(1)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(8)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GUSTER_BANNER_PATTERN).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_PRECIPICE).setWeight(1)));
    }

    public LootTable.Builder strongBreezeTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.HEAVY_CORE).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLOW_POTTERY_SHERD).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLOW_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLOW_BANNER_PATTERN).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSIC_DISC_CREATOR).setWeight(1)));
    }

    public LootTable.Builder evokerTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TOTEM_OF_UNDYING).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OMINOUS_BOTTLE).setWeight(1)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.5f, (float)2.0f))));
    }

    public LootTable.Builder witchLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EXPERIENCE_BOTTLE).setWeight(8)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.HONEY_BOTTLE).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OMINOUS_BOTTLE).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.POTION).setWeight(1).apply((LootItemFunction.Builder)SetPotionFunction.setPotion((Holder)Potions.WATER)))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)));
    }

    public LootTable.Builder blazeLootTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BLAZE_ROD)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BLAZE_POWDER)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)13.0f)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_WART).setWeight(30)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CRIMSON_FUNGUS).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WARPED_FUNGUS).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_MUSHROOM).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BROWN_MUSHROOM).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CRIMSON_ROOTS).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WARPED_ROOTS).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WEEPING_VINES).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TWISTING_VINES).setWeight(5)).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHERRACK).setWeight(45)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_QUARTZ_ORE).setWeight(25)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CRIMSON_NYLIUM).setWeight(9)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WARPED_NYLIUM).setWeight(9)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_WART_BLOCK).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WARPED_WART_BLOCK).setWeight(1)).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(25)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SOUL_SAND).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SOUL_SOIL).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BASALT).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BLACKSTONE).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GRAVEL).setWeight(9)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE_BLOCK).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GILDED_BLACKSTONE).setWeight(1)).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GLOWSTONE_DUST).setWeight(25).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MAGMA_BLOCK).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GLOWSTONE).setWeight(9)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHROOMLIGHT).setWeight(1)).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(75)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OBSIDIAN).setWeight(20)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CRYING_OBSIDIAN).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ANCIENT_DEBRIS).setWeight(1)).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)ConstantValue.exactly((float)1.0f))));
    }
}

