/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;

public abstract class SingleInputRecipe<T extends RecipeInput>
implements Recipe<T> {
    protected final Ingredient input;
    protected final ItemStack output;

    public SingleInputRecipe(Ingredient input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public boolean matches(T inv, Level level) {
        return this.input.test(inv.getItem(0));
    }

    public ItemStack assemble(T pCraftingContainer, HolderLookup.Provider pRegistries) {
        return this.getResultItem(pRegistries).copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.output;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.input});
    }
}

