/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.level.cave;

import com.klikli_dev.occultism.common.level.cave.CaveDecoratordata;
import com.klikli_dev.occultism.common.level.cave.ICaveDecorator;
import com.klikli_dev.occultism.common.level.multichunk.IMultiChunkSubFeature;
import com.klikli_dev.occultism.common.level.multichunk.MultiChunkFeature;
import com.klikli_dev.occultism.common.level.multichunk.MultiChunkFeatureConfig;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.phys.AABB;

public class SphericalCaveSubFeature
implements IMultiChunkSubFeature {
    public static Set<BlockPos> sphericalCaves = new HashSet<BlockPos>();
    protected ICaveDecorator caveDecorator;
    protected int radius;
    protected int maxRandomRadiusOffset;

    public SphericalCaveSubFeature(ICaveDecorator caveDecorator, int radius, int maxRandomRadiusOffset) {
        this.caveDecorator = caveDecorator;
        this.radius = radius;
        this.maxRandomRadiusOffset = maxRandomRadiusOffset;
    }

    @Override
    public boolean place(WorldGenLevel reader, ChunkGenerator generator, RandomSource rand, BlockPos rootPosition, AABB bounds, MultiChunkFeatureConfig config) {
        if (reader.canSeeSkyFromBelowWater(rootPosition)) {
            return false;
        }
        sphericalCaves.add(rootPosition);
        ChunkPos rootChunk = new ChunkPos(rootPosition);
        long seed = MultiChunkFeature.getLargeFeatureWithSaltSeed(reader.getSeed(), rootChunk.x, rootChunk.z, config.featureSeedSalt);
        rand.setSeed(seed);
        ArrayList<Sphere> spheres = new ArrayList<Sphere>();
        int radiusBase = this.radius + rand.nextInt(this.maxRandomRadiusOffset);
        int radius = (int)((float)radiusBase * 0.2f) + rand.nextInt(8);
        spheres.add(this.generateSphere(reader, rand, rootPosition, radius, bounds));
        for (Sphere sphere : spheres) {
            this.closeOutSphere(reader, sphere.center, sphere.radius + 3, bounds);
            this.hollowOutSphere(reader, rand, sphere.center, sphere.radius - 1, bounds);
            this.decorateSphere(reader, generator, rand, sphere.center, sphere.radius + 1, bounds, config);
        }
        spheres.clear();
        return true;
    }

    protected Sphere generateSphere(WorldGenLevel level, RandomSource rand, BlockPos position, int radius, AABB bounds) {
        return new Sphere(this, position, radius);
    }

    protected void hollowOutSphere(WorldGenLevel reader, RandomSource rand, BlockPos center, int radius, AABB bounds) {
        int j = radius;
        int k = radius / 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos min = Math3DUtil.clamp(center.offset(-j, -k, -l), bounds);
        BlockPos max = Math3DUtil.clamp(center.offset(j, k, l), bounds);
        BlockPos.betweenClosed((BlockPos)min, (BlockPos)max).forEach(blockPos -> {
            if (blockPos.distSqr((Vec3i)center) <= (double)(f * f * Mth.clamp((float)rand.nextFloat(), (float)0.75f, (float)1.0f))) {
                BlockState currentState = reader.getBlockState(blockPos);
                this.setBlockSafely(reader, (BlockPos)blockPos, currentState, Blocks.CAVE_AIR.defaultBlockState(), 2);
            }
        });
    }

    protected void closeOutSphere(WorldGenLevel reader, BlockPos center, int radius, AABB bounds) {
        int k = radius / 2;
        float f = (float)(2 * radius + k) * 0.333f + 0.5f;
        BlockPos min = Math3DUtil.clamp(center.offset(-radius, -k, -radius), bounds);
        BlockPos max = Math3DUtil.clamp(center.offset(radius, k + 2, radius), bounds);
        BlockPos.betweenClosed((BlockPos)min, (BlockPos)max).forEach(blockPos -> {
            if (blockPos.distSqr((Vec3i)center) <= (double)(f * f)) {
                BlockState currentState = reader.getBlockState(blockPos);
                this.setBlockSafely(reader, (BlockPos)blockPos, currentState, Blocks.STONE.defaultBlockState(), 2);
            }
        });
    }

    protected void decorateSphere(WorldGenLevel reader, ChunkGenerator generator, RandomSource rand, BlockPos center, int radius, AABB bounds, MultiChunkFeatureConfig config) {
        int j = radius;
        int k = radius / 2;
        int l = radius;
        CaveDecoratordata data = new CaveDecoratordata();
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos min = Math3DUtil.clamp(center.offset(-j, -k, -l), bounds);
        BlockPos max = Math3DUtil.clamp(center.offset(j, k, l), bounds);
        BlockPos.betweenClosed((BlockPos)min, (BlockPos)max).forEach(blockPos -> {
            if (blockPos.distSqr((Vec3i)center) <= (double)(f * f)) {
                this.caveDecorator.fill(reader, generator, rand, blockPos.immutable(), data, config);
            }
        });
        this.caveDecorator.finalPass(reader, generator, rand, data, config);
    }

    protected void setBlockSafely(WorldGenLevel level, BlockPos pPos, BlockState pCurrentState, BlockState pNewState, int pFlags) {
        if (pCurrentState.hasBlockEntity() || pCurrentState.getBlock() == Blocks.BEDROCK || pCurrentState.is(OccultismTags.Blocks.WORLDGEN_BLACKLIST)) {
            return;
        }
        level.setBlock(pPos, pNewState, pFlags);
    }

    public class Sphere {
        public BlockPos center;
        public int radius;

        public Sphere(SphericalCaveSubFeature this$0, BlockPos center, int radius) {
            this.center = center;
            this.radius = radius;
        }
    }
}

