/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.possessed.horde;

import com.klikli_dev.occultism.common.entity.possessed.horde.WildSilverfishEntity;
import com.klikli_dev.occultism.common.entity.possessed.horde.WildSkeletonEntity;
import com.klikli_dev.occultism.common.entity.possessed.horde.WildZombieEntity;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;

public class PossessedWeakBreezeEntity
extends Breeze {
    List<WildZombieEntity> minionsA = new ArrayList<WildZombieEntity>();
    List<WildSkeletonEntity> minionsB = new ArrayList<WildSkeletonEntity>();
    List<WildSilverfishEntity> minionsC = new ArrayList<WildSilverfishEntity>();

    public PossessedWeakBreezeEntity(EntityType<? extends Breeze> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Breeze.createAttributes();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        double offsetZ;
        double offsetX;
        Object entity;
        int i;
        for (i = 0; i < 3; ++i) {
            entity = (WildZombieEntity)OccultismEntities.WILD_ZOMBIE.get().create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, (float)level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
            ((WildZombieEntity)((Object)entity)).setMaster(this);
            this.minionsA.add((WildZombieEntity)((Object)entity));
        }
        for (i = 0; i < 3; ++i) {
            entity = (WildSkeletonEntity)OccultismEntities.WILD_SKELETON.get().create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, (float)level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
            ((WildSkeletonEntity)((Object)entity)).setMaster(this);
            this.minionsB.add((WildSkeletonEntity)((Object)entity));
        }
        for (i = 0; i < 3; ++i) {
            entity = (WildSilverfishEntity)OccultismEntities.WILD_SILVERFISH.get().create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, (float)level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
            ((WildSilverfishEntity)((Object)entity)).setMaster(this);
            this.minionsC.add((WildSilverfishEntity)((Object)entity));
        }
        return super.finalizeSpawn(level, difficultyIn, reason, spawnDataIn);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (this.isInvulnerable()) {
            this.minionsA.forEach(e -> e.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 0, false, false)));
            this.minionsB.forEach(e -> e.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 0, false, false)));
            this.minionsC.forEach(e -> e.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 0, false, false)));
            return true;
        }
        TagKey<EntityType<?>> wildTrialTag = OccultismTags.Entities.WILD_TRIAL;
        Entity trueSource = source.getEntity();
        if (trueSource != null && trueSource.getType().is(wildTrialTag)) {
            return true;
        }
        Entity immediateSource = source.getDirectEntity();
        if (immediateSource != null && immediateSource.getType().is(wildTrialTag)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean isInvulnerable() {
        return !this.minionsA.isEmpty() || !this.minionsB.isEmpty() || !this.minionsC.isEmpty() || super.isInvulnerable();
    }

    public void notifyMinionDeath(WildZombieEntity minion) {
        this.minionsA.remove((Object)minion);
    }

    public void notifyMinionDeath(WildSkeletonEntity minion) {
        this.minionsB.remove((Object)minion);
    }

    public void notifyMinionDeath(WildSilverfishEntity minion) {
        this.minionsC.remove((Object)minion);
    }
}

