/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.possessed.horde;

import com.klikli_dev.occultism.util.TextUtil;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;

public class PossessedEvokerEntity
extends Evoker {
    public PossessedEvokerEntity(EntityType<? extends Evoker> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Evoker.createAttributes().add(Attributes.MAX_HEALTH, 42.0).add(Attributes.ARMOR, 7.0);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        double offsetZ;
        double offsetX;
        Vindicator entity;
        int i;
        for (i = 0; i < 2; ++i) {
            entity = (Vindicator)EntityType.VINDICATOR.create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, (float)level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
        }
        for (i = 0; i < 5; ++i) {
            entity = (Pillager)EntityType.PILLAGER.create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, (float)level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
        }
        for (i = 0; i < 1; ++i) {
            entity = (Illusioner)EntityType.ILLUSIONER.create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, (float)level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
        }
        for (i = 0; i < 1; ++i) {
            entity = (Ravager)EntityType.RAVAGER.create(this.level());
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)level, (DifficultyInstance)difficultyIn, (MobSpawnType)reason, (SpawnGroupData)spawnDataIn);
            offsetX = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            offsetZ = level.getRandom().nextGaussian() * (double)(1 + level.getRandom().nextInt(4));
            entity.absMoveTo((double)this.getBlockX() + offsetX, (double)this.getBlockY() + 1.5, (double)this.getBlockZ() + offsetZ, (float)level.getRandom().nextInt(360), 0.0f);
            entity.setCustomName((Component)Component.literal((String)TextUtil.generateName()));
            level.addFreshEntity((Entity)entity);
        }
        return super.finalizeSpawn(level, difficultyIn, reason, spawnDataIn);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }
}

